package com.testor.module.train.myManagement.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.train.myManagement.model.domain.TTrainGrade;
import com.testor.module.train.myManagement.model.domain.TTrainMyManagement;
import com.testor.module.train.myManagement.model.dto.TTrainGradeDelParam;
import com.testor.module.train.myManagement.model.dto.TTrainGradeParam;
import com.testor.module.train.myManagement.service.TTrainGradeService;
import com.testor.module.train.myManagement.service.TTrainMyManagementService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.common.models.sys.UserInfo;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * 评分-安全教育培训Controller
 *
 * @author testor-framework
 * @date 2022-11-17 15:26:58
 */
@RestController
@RequestMapping("/module/grade")
@Api(value = "TTrainGrade", tags = "评分-安全教育培训")
@Slf4j
public class TTrainGradeController extends SuperController
{
    @Autowired
    private TTrainGradeService tTrainGradeService;

	@Autowired
	private TTrainMyManagementService tTrainMyManagementService;

    /* Generated Method*/
//	@ApiOperation(value = "新增 评分-安全教育培训", notes = "Add TTrainGrade")
//	@PostMapping(value = "/add")
	public BaseResponse<TTrainGrade>addEntity(@RequestBody TTrainGrade addRequest) {
		BaseResponse<TTrainGrade> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(addRequest)){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
			String id = IdHelper.getId32bit();
            TTrainGrade data=BeanHelper.beanToBean(addRequest,  TTrainGrade.class);
			data.setId(id);
			boolean result= tTrainGradeService.save(data);
			if(result){
                TTrainGrade newEntity = new TTrainGrade();
				newEntity.setId(id);
				baseResponse.setData(newEntity);
			}
		}
		return baseResponse;
	}

//	@ApiOperation(value = "获取 评分-安全教育培训 ", notes = "Get TTrainGrade By Id")
//	@GetMapping(value = "/get")
	public BaseResponse<TTrainGrade> getById(String id){
		BaseResponse<TTrainGrade> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(id)){
			// TODO 按需求添加业务异常判断
            TTrainGrade data= tTrainGradeService.getById(id);
			baseResponse.setData(data);
		}
		return baseResponse;
	}

//	@ApiOperation(value = "修改 评分-安全教育培训 ", notes = "Update TTrainGrade By Id")
//	@PutMapping(value = "/update")
	public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TTrainGrade updateRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TTrainGrade data=BeanHelper.beanToBean(updateRequest, TTrainGrade.class);
			boolean result= tTrainGradeService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

//	@ApiOperation(value = "删除 评分-安全教育培训 ", notes = "delete TTrainGrade By Id")
//	@PutMapping(value = "/delete")
	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TTrainGradeDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TTrainGrade data= new TTrainGrade();
			data.setId(deleteRequest.getId());
			data.setStatus(BizConstants.STATUS_DELETE);
			boolean result= tTrainGradeService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

//	@ApiOperation(value = "批量删除评分-安全教育培训", notes = "delete TTrainGrade by batch Id")
//	@PutMapping(value = "/batch_delete")
	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
			@RequestBody TTrainGradeDelParam deleteRequest) {
		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
			List<TTrainGrade> tTrainGradeList = new ArrayList<>();
            for(String id: deleteRequest.getIds()){
                TTrainGrade data= new TTrainGrade();
				data.setId(id);
				data.setStatus(BizConstants.STATUS_DELETE);
                tTrainGradeList.add(data);
			}
			boolean result = tTrainGradeService.updateBatchById(tTrainGradeList);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

//	@ApiOperation(value = "获取 评分-安全教育培训 分页列表", notes = "List TTrainGrade with page")
//	@GetMapping(value = "/list")
	public  BaseResponse<BaseResponseList<TTrainGrade>>listEntity(TTrainGradeParam param){
		BaseResponse<BaseResponseList<TTrainGrade>>baseResponse=new BaseResponse<>();
		Long page=
				StringHelper.isEmpty(param.getPage())?BizConstants.PAGE:Long.valueOf(param.getPage());
		Long limit=
				StringHelper.isEmpty(param.getLimit())?BizConstants.LIMIT:Long.valueOf(param.getLimit());
		Page<TTrainGrade> resultPage=new Page<>(page,limit);
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<TTrainGrade> queryWrapper=this.createQuery(param);
		Page<TTrainGrade> resultList= tTrainGradeService.page(resultPage,queryWrapper);
		BaseResponseList<TTrainGrade> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 评分-安全教育培训 列表", notes = "List TTrainGrade all")
	@GetMapping(value = "/datas")
	public  BaseResponse<BaseResponseList<TTrainGrade>>listAllEntity(TTrainGradeParam param){
		BaseResponse<BaseResponseList<TTrainGrade>>baseResponse=new BaseResponse<>();
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<TTrainGrade> queryWrapper=this.createQuery(param);
		List<TTrainGrade> resultList=tTrainGradeService.list(queryWrapper);
		BaseResponseList<TTrainGrade> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 评分-安全教育培训 详情", notes = "List TTrainGrade details")
	@GetMapping(value = "/getDetails")
	public  BaseResponse<BaseResponseList<TTrainGrade>>getDetails(String id){
		//todo 获取登录人信息
		UserInfo loginUser = ContextUtils.getLoginUser();
		TTrainMyManagement tTrainMyManagement = tTrainMyManagementService.getById(id);
		// 获取任务id
		String taskId = tTrainMyManagement.getTaskId();
		// 获取评分人
		String personId = tTrainMyManagement.getPersonId();
		TTrainGradeParam param =new TTrainGradeParam();
		param.setOrgId(loginUser.getOrgId());
		param.setTaskId(taskId);
		param.setUserId(personId);
		BaseResponse<BaseResponseList<TTrainGrade>>baseResponse=new BaseResponse<>();
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<TTrainGrade> queryWrapper=this.createQuery(param);
		List<TTrainGrade> resultList=tTrainGradeService.list(queryWrapper);
		BaseResponseList<TTrainGrade> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

    /* Private Methods */
	/**
     * 列表查询条件及查询参数
     */
	private QueryWrapper<TTrainGrade> createQuery(TTrainGradeParam queryParam){
		QueryWrapper<TTrainGrade> queryWrapper=new QueryWrapper<>();
		if(StringHelper.isNotEmpty(queryParam.getOrgName())){
			queryWrapper.like(TTrainGrade.ORG_NAME,queryParam.getOrgName());
		}
		if(StringHelper.isNotEmpty(queryParam.getOrgId())){
			queryWrapper.eq(TTrainGrade.ORG_ID,queryParam.getOrgId());
		}
		if(StringHelper.isNotEmpty(queryParam.getTaskId())){
			queryWrapper.eq(TTrainGrade.TASK_ID,queryParam.getTaskId());
		}
		if (StringHelper.isNotEmpty(queryParam.getStatus())) {
			queryWrapper.eq(TTrainGrade.STATUS, queryParam.getStatus());
		} else {
			queryWrapper.ne(TTrainGrade.STATUS, BizConstants.STATUS_DELETE);
		}
		if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
			if(StringHelper.isNotEmpty(queryParam.getOrderType())
					&&BizConstants.ASC.equals(queryParam.getOrderType())){
				queryWrapper.orderByAsc(queryParam.getOrderBy());
			}else{
				queryWrapper.orderByDesc(queryParam.getOrderBy());
			}
		}else{
			queryWrapper.orderByDesc(TTrainGrade.UPDATE_DATE);
		}
		return queryWrapper;
	}
}
