package com.testor.module.train.myManagement.model.domain;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.Date;


/**
 * 我的培训教育及考试—安全培训教育对象 t_train_my_management
 * 
 * @author testor-framework
 * @date 2022-07-28 15:25:02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_train_my_management")
@ApiModel(value = "TTrainMyManagement对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TTrainMyManagement extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * 主键ID
 */
  @ApiModelProperty(value = "主键ID")

  @TableId("id")
  private String id;
/**
 * 父级ID
 */
  @ApiModelProperty(value = "父级ID")

  @TableField("parent_id")
  private String parentId;
/**
 * 人员id
 */
  @ApiModelProperty(value = "人员id")

  @TableField("person_id")
  private String personId;
/**
 * 关联任务id
 */
  @ApiModelProperty(value = "关联任务id")

  @TableField("task_id")
  private String taskId;
/**
 * 任务类型
 */
  @ApiModelProperty(value = "类型")

  @TableField("task_type")
  private String taskType;
/**
 * 人员归属 本单位/相关方
 */
  @ApiModelProperty(value = "人员归属 本单位/相关方")

  @TableField("person_affiliation")
  private String personAffiliation;
/**
 * 所属企业
 */
  @ApiModelProperty(value = "所属企业")

  @TableField("company")
  private String company;
/**
 * 所属部门
 */
  @ApiModelProperty(value = "所属部门")

  @TableField("dept_name")
  private String deptName;
/**
 * 人员姓名id
 */
  @ApiModelProperty(value = "人员姓名id")

  @TableField("person_name_id")
  private String personNameId;
/**
 * 人员姓名
 */
  @ApiModelProperty(value = "人员姓名")

  @TableField("person_name")
  private String personName;
/**
 * 性别
 */
  @ApiModelProperty(value = "性别")

  @TableField("sex")
  private String sex;
/**
 * 学习情况
 */
  @ApiModelProperty(value = "学习情况(仅当为考试计划时 0 待考试 1 通过 2 未通过)")

  @TableField("percentage")
  private String percentage;
/**
 * 租户id
 */
  @ApiModelProperty(value = "租户id")

  @TableField("tenant_id")
  private String tenantId;
/**
 * 流程实例ID
 */
  @ApiModelProperty(value = "流程实例ID")

  @TableField("process_id")
  private String processId;
/**
 * 流程状态
 */
  @ApiModelProperty(value = "流程状态")

  @TableField("process_status")
  private String processStatus;
  /**
   * 组织机构id
   */
  @ApiModelProperty(value = "组织机构id")

  @TableField("org_id")
  private String orgId;
  /**
   * 当前状态
   */
  @ApiModelProperty(value = "当前状态 0 未开始 1 进行中 3 已完成 5 逾期未完成")

  @TableField("current_status")
  private String currentStatus;
  /**
   * 是否考试
   */
  @ApiModelProperty(value = "是否考试 1 是 0 否")

  @TableField("is_add_exam")
  private String isAddExam;

  @ApiModelProperty(value = "tab切换，1 课程 2 考试 3 练习")
  @TableField("tab_status")
  private String tabStatus;

  @ApiModelProperty(value = "培训项目名称")
  @TableField("task_name")
  private String taskName;

  @ApiModelProperty(value = "学习方式 0 线上 1 线下 2 自主 3 (随机考试)线上")
  @TableField("learn_way")
  private String learnWay;

  @ApiModelProperty(value = "计划开始时间")
  @TableField("visit_start_time")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JSONField(format = "yyyy-MM-dd HH:mm:ss")
   private  Date  visitStartTime;

  @ApiModelProperty(value = "计划结束时间")
  @TableField("visit_end_time")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JSONField(format = "yyyy-MM-dd HH:mm:ss")
  private Date visitEndTime;

  @ApiModelProperty(value = "试题数量")
  @TableField("test_questions_num")
  private String testQuestionsNum;

  @ApiModelProperty(value = "练习数量")
  @TableField("exercise_num")
  private String exerciseNum;

  @ApiModelProperty(value = "练习率")
  @TableField("exercise_rate")
  private String exerciseRate;

  @ApiModelProperty(value = "错题数")
  @TableField("errors_num")
  private String errorsNum;

  @ApiModelProperty(value = "试卷id")
  @TableField("test_paper_id")
  private String testPaperId;

  @ApiModelProperty(value = "考试成绩")
  @TableField("test_score")
  private String testScore;

  @ApiModelProperty(value = "补考成绩")
  @TableField("repair_test")
  private String repairTest;

  @ApiModelProperty(value = "考试时长")
  @TableField("exam_duration")
  private String examDuration;
  public static final String ID ="id";
  public static final String PARENT_ID ="parent_id";
  public static final String PERSON_ID ="person_id";
  public static final String TASK_ID ="task_id";
  public static final String TASK_TYPE ="task_type";
  public static final String PERSON_AFFILIATION ="person_affiliation";
  public static final String COMPANY ="company";
  public static final String DEPT_NAME ="dept_name";
  public static final String PERSON_NAME_ID ="person_name_id";
  public static final String PERSON_NAME ="person_name";
  public static final String SEX ="sex";
  public static final String PERCENTAGE ="percentage";
  public static final String TENANT_ID ="tenant_id";
  public static final String PROCESS_ID ="process_id";
  public static final String PROCESS_STATUS ="process_status";
  public static final String ORG_ID ="org_id";
  public static final String IS_ADD_EXAM ="is_add_exam";
  public static final String TAB_STATUS ="tab_status";
  public static final String TASK_NAME ="task_name";
  public static final String LEARN_WAY ="learn_way";
  public static final String CURRENT_STATUS ="current_status";
  public static final String VISIT_START_TIME ="visit_start_time";
  public static final String VISIT_END_TIME ="visit_end_time";
  public static final String TEST_QUESTIONS_NUM ="test_questions_num";
  public static final String EXERCISE_NUM ="exercise_num";
  public static final String EXERCISE_RATE ="exercise_rate";
  public static final String ERRORS_NUM ="errors_num";
  public static final String TEST_PAPER_ID ="test_paper_id";
  public static final String TEST_SCORE ="test_score";
  public static final String REPAIR_TEST ="repair_test";
  public static final String EXAM_DURATION ="exam_duration";

}
