package com.testor.module.train.project.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.biz.file.model.dto.FileDTO;
import com.testor.common.core.utils.StringUtils;
import com.testor.module.aptitude.model.domain.TPersonAptitudeDto;
import com.testor.module.notice.model.domain.TSysFile;
import com.testor.module.notice.service.TSysFileService;
import com.testor.module.train.project.model.domain.TrainExamsExternalInfo;
import com.testor.module.train.project.model.stat.TrainExamsExternalInfoPara;
import com.testor.module.train.project.model.stat.TrainExamsExternalInfoVo;
import com.testor.module.train.project.service.TrainExamsExternalInfoService;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 记录用户外部培训和考试信息 前端控制器
 * </p>
 *
 * @author caoqiang
 * @since 2024-09-07
 */
@RestController
@RequestMapping("/trainExamsExternalInfo")
@Api(value = "TrainExamsExternalInfoController", tags = "记录用户外部培训和考试信息接口")
@Slf4j
public class TrainExamsExternalInfoController extends SuperController {

    @Autowired
    private TrainExamsExternalInfoService tTrainEvaluateManageService;
    @Autowired
    private TSysFileService tSysFileService;

    @ApiOperation(value = "列表 ", notes = "列表")
    @GetMapping(value = "/list")
    public BaseResponse<BaseResponseList<TrainExamsExternalInfo>> listBaseResponse(TrainExamsExternalInfoPara para) {
        convertPara(para);
        Page<TrainExamsExternalInfo> pagePara = new Page<>(Integer.parseInt(para.getPage()), Integer.parseInt(para.getLimit()));
        Page<TrainExamsExternalInfo> resultPage = tTrainEvaluateManageService.lambdaQuery().eq(TrainExamsExternalInfo::getUserId, para.getUserId()).page(pagePara);
        BaseResponseList<TrainExamsExternalInfo> baseResponseList = new BaseResponseList<>();
        baseResponseList.setData(resultPage.getRecords());
        baseResponseList.setTotal(resultPage.getTotal());
        BaseResponse<BaseResponseList<TrainExamsExternalInfo>> baseResponse = new BaseResponse<>();
        baseResponse.setData(baseResponseList);
        return baseResponse;
    }

    @ApiOperation(value = "新增 ", notes = "新增")
    @PostMapping(value = "/add")
    public BaseResponse<Boolean> add(@RequestBody TrainExamsExternalInfo para) {
        para.setCreateBy(ContextUtils.getLoginUser().getUserId());
        para.setCreateDate(new Date());
        para.setUpdateBy(ContextUtils.getLoginUser().getUserId());
        para.setUpdateDate(new Date());
        para.setStatus("0");
        para.setId(IdHelper.getId32bit());
        boolean save = tTrainEvaluateManageService.save(para);
        BaseResponse<Boolean> baseResponse = new BaseResponse<>();
        baseResponse.setData(save);
        return baseResponse;
    }

    @ApiOperation(value = "修改 ", notes = "修改")
    @PostMapping(value = "/update")
    public BaseResponse<Boolean> update(@RequestBody TrainExamsExternalInfo para) {
        para.setUpdateBy(ContextUtils.getLoginUser().getUserId());
        para.setUpdateDate(new Date());
        para.setStatus("0");
        boolean save = tTrainEvaluateManageService.updateById(para);
        BaseResponse<Boolean> baseResponse = new BaseResponse<>();
        baseResponse.setData(save);
        return baseResponse;
    }

    @ApiOperation(value = "详情 ", notes = "详情")
    @GetMapping(value = "/detail")
    public BaseResponse<TrainExamsExternalInfoVo> detail(String id) {
        TrainExamsExternalInfo info = tTrainEvaluateManageService.getById(id);
        TrainExamsExternalInfoVo infoVo = BeanHelper.beanToBean(info, TrainExamsExternalInfoVo.class);
        String refId = info.getRefId();
        if (StringUtils.isNotBlank(refId)) {
            String[] split = refId.split(",");
            List<FileDTO> fileDTOS = new ArrayList<>();
            for (String s : split) {
                FileDTO fileDTO = new FileDTO();
                TSysFile tSysFile = tSysFileService.getById(s);
                if (tSysFile != null && !(tSysFile.getStatus().equals("1"))) {
                    fileDTO.setFilePath(tSysFile.getFilePath());
                    fileDTO.setFileName(tSysFile.getFileName());
                    fileDTO.setFileDowName(tSysFile.getFileDowName());
                    fileDTO.setFileId(s);
                    fileDTOS.add(fileDTO);
                }
            }
            infoVo.setFileDTOS(fileDTOS);
        }
        BaseResponse<TrainExamsExternalInfoVo> baseResponse = new BaseResponse<>();
        baseResponse.setData(infoVo);
        return baseResponse;
    }



    private void convertPara(TrainExamsExternalInfoPara para) {
        String userId = para.getUserId();
        String page = para.getPage();
        String limit = para.getLimit();
        if (StringUtils.isAnyBlank(page, limit)) {
            para.setPage("1");
            para.setLimit("10");
        }
        if (StringUtils.isBlank(userId)) {
            userId = ContextUtils.getLoginUser().getUserId();
            para.setUserId(userId);
        }
    }


}
