package com.testor.module.train.project.dao;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.train.project.model.domain.TTrainProject;
import com.testor.module.train.project.model.dto.TTrainProjectParam;
import com.testor.module.train.project.model.stat.ProjectErrorQuesVo;
import com.testor.module.train.project.model.stat.ProjectScoreStatVo;
import com.testor.module.train.project.model.stat.ProjectStatTotalVo;
import com.tongtech.tfw.backend.common.models.supers.SuperDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 教育培训计划—安全培训教育Mapper接口
 *
 * @author testor-framework
 * @date 2022-07-28 15:15:20
 */
public interface TTrainProjectDao extends SuperDao<TTrainProject> {
    IPage<TTrainProjectParam> getAffiliation(Page<TTrainProjectParam> resultPage, @Param("param") TTrainProjectParam param,@Param("parentIds") String parentIds,@Param("orgId") String orgId);
    List<TTrainProjectParam> getAffiliation( @Param("param") TTrainProjectParam param,@Param("parentIds") String parentIds,@Param("orgId") String orgId);

    List<TTrainProjectParam> getProjectPerson(@Param("id") String id);


    /**
     *  查询培训计划应学人数和总培训时长
     * @param orgIdList
     * @param startTime
     * @param endTime
     * @param projectId
     * @return
     */
    ProjectStatTotalVo findProjectTotalTime(@Param("list") List<String> orgIdList,
                                            @Param("startTime") String startTime,
                                            @Param("endTime") String endTime,
                                            @Param("projectId") String projectId);
    /**
     * 查询已完成培训的人数
     * @param orgIdList
     * @param startTime
     * @param endTime
     * @param projectId
     * @return
     */
    ProjectStatTotalVo findTrainProjectCompleted(@Param("list") List<String> orgIdList,
                                                      @Param("startTime") String startTime,
                                                      @Param("endTime") String endTime,
                                                      @Param("projectId") String projectId);


    IPage<TTrainProjectParam> findProjectPersonList(Page<TTrainProjectParam> resultPage,
                                                    @Param("list") List<String> orgIdList,
                                                    @Param("startTime") String startTime,
                                                    @Param("endTime") String endTime,
                                                    @Param("projectId") String projectId);

    List<ProjectStatTotalVo> findProjectNumByOrgOrVisitType(@Param("list") List<String> orgIdList,
                                                            @Param("startTime") String startTime,
                                                            @Param("endTime") String endTime,
                                                            @Param("chartType") String chartType);

    String findProjectNumByOrgId(@Param("list") List<String> orgIdList,
                                                            @Param("startTime") String startTime,
                                                            @Param("endTime") String endTime);



    List<ProjectStatTotalVo> findPersonNumByOrgOrVisitType(@Param("list") List<String> orgIdList,
                                                            @Param("startTime") String startTime,
                                                            @Param("endTime") String endTime,
                                                            @Param("chartType") String chartType);


    String findPersonNumByOrgOrgId(@Param("list") List<String> orgIdList,
                                   @Param("startTime") String startTime,
                                   @Param("endTime") String endTime);


    List<ProjectStatTotalVo> findTrainTimeByOrgOrVisitType(@Param("list") List<String> orgIdList,
                                                           @Param("startTime") String startTime,
                                                           @Param("endTime") String endTime,
                                                           @Param("chartType") String chartType);

    String findTrainTimeSumByOrgId(@Param("list") List<String> orgIdList,
                                                           @Param("startTime") String startTime,
                                                           @Param("endTime") String endTime);



    String findTrainTimeTotal(@Param("startTime") String startTime,
                              @Param("endTime") String endTime  );

    ProjectStatTotalVo findGradeStat(@Param("list") List<String> orgIdList,
                                     @Param("startTime") String startTime,
                                     @Param("endTime") String endTime,
                                     @Param("projectId") String projectId);


    List<ProjectStatTotalVo> findTrainTypeStat(@Param("list") List<String> orgIdList,
                                               @Param("startTime") String startTime,
                                               @Param("endTime") String endTime);


    ProjectScoreStatVo findExamStates(@Param("projectId") String projectId);

    List<String> findScoreStat(@Param("projectId") String projectId);


}
