package com.testor.module.video.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.util.List;


/**
 * 视频监控——设备信息对象 t_video_equipment_info
 * 
 * @author testor-framework
 * @date 2022-11-18 11:41:23
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_video_equipment_info")
@ApiModel(value = "TVideoEquipmentInfo对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TVideoEquipmentInfo extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * 主键ID
 */
  @ApiModelProperty(value = "主键ID")

  @TableId("id")
  private String id;
/**
 * 关联ID
 */
  @ApiModelProperty(value = "关联ID")

  @TableField("ref_id")
  private String refId;
/**
 * 父级ID
 */
  @ApiModelProperty(value = "父级ID")

  @TableField("parent_id")
  private String parentId;
/**
 * 租户id
 */
  @ApiModelProperty(value = "租户id")

  @TableField("tenant_id")
  private String tenantId;
/**
 * 流程实例ID
 */
  @ApiModelProperty(value = "流程实例ID")

  @TableField("process_id")
  private String processId;
/**
 * 流程状态
 */
  @ApiModelProperty(value = "流程状态")

  @TableField("process_status")
  private String processStatus;
/**
 * 所属粮库id
 */
  @ApiModelProperty(value = "所属粮库id")

  @TableField("org_id")
  private String orgId;
/**
 * 所属粮库名称
 */
  @ApiModelProperty(value = "所属粮库名称")

  @TableField("org_name")
  private String orgName;
/**
 * 设备名称
 */
  @ApiModelProperty(value = "设备名称")

  @TableField("equipment_name")
  private String equipmentName;

  /**
 * 设备名称
 */
  @ApiModelProperty(value = "坐标X")
  @TableField("coor_x")
  private String coorX;/**
 * 设备名称
 */
  @ApiModelProperty(value = "坐标Y")
  @TableField("coor_y")
  private String coorY;/**
 * 设备名称
 */
  @ApiModelProperty(value = "坐标Z")
  @TableField("coor_z")
  private String coorZ;
/**
 * 安装位置
 */
  @ApiModelProperty(value = "安装位置")

  @TableField("installation_location")
  private String installationLocation;
/**
 * 设备国标id
 */
  @ApiModelProperty(value = "设备国标id")

  @TableField("device_id")
  private String deviceId;
/**
 * 监控位置，多个用逗号隔开
 */
  @ApiModelProperty(value = "监控位置，多个用逗号隔开")

  @TableField("monitor_location")
  private String monitorLocation;

  @ApiModelProperty(value = "监控位置名称，多个用逗号隔开")
  @TableField(exist = false)
  private List<String> monitorLocationName;
/**
 * 是否盯防，0不是盯防，1是盯防
 */
  @ApiModelProperty(value = "是否盯防，0不是盯防，1是盯防" , example = "0")

  @TableField("is_eye")
  private Integer isEye;

  @ApiModelProperty("空间场所id，多个用逗号隔开")
  @TableField("space_id")
  private String spaceId;
  @ApiModelProperty("空间场所类型id，多个用逗号隔开")
  @TableField("space_type_id")
  private String spaceTypeId;

  @ApiModelProperty("位置：1.内，2.外")
  @TableField("position")
  private String position;


  public static final String ID ="id";
  public static final String REF_ID ="ref_id";
  public static final String PARENT_ID ="parent_id";
  public static final String TENANT_ID ="tenant_id";
  public static final String PROCESS_ID ="process_id";
  public static final String PROCESS_STATUS ="process_status";
  public static final String ORG_ID ="org_id";
  public static final String ORG_NAME ="org_name";
  public static final String EQUIPMENT_NAME ="equipment_name";
  public static final String INSTALLATION_LOCATION ="installation_location";
  public static final String DEVICE_ID ="device_id";
  public static final String MONITOR_LOCATION ="monitor_location";
  public static final String IS_EYE ="is_eye";
  public static final String POSITION ="position";


}
