package com.testor.module.video.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.video.dao.VideoAlarmDao;
import com.testor.module.video.model.domain.VideoEquipmentInfo;
import com.testor.module.video.model.domain.VideoQueryParam;
import com.testor.module.video.service.VideoAlarmService;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * (VideoAlarm)视频告警 -- 表服务接口实现类
 *
 * @author makejava
 * @since 2022-06-01 11:23:56
 */
@Service("videoAlarmService")
@Slf4j
public class VideoAlarmServiceImpl extends SuperServiceImpl<VideoAlarmDao, VideoEquipmentInfo> implements VideoAlarmService {

    @Autowired
    private VideoAlarmDao videoAlarmDao;

    @Override
    public BaseResponse updateVideo(VideoEquipmentInfo videoEquipmentInfo) {
        return null;
    }

    @Override
    public IPage<VideoEquipmentInfo> myPage(Page<VideoEquipmentInfo> resultPage, VideoQueryParam param) {
        //根据级别判断调用那个sql
        Integer mark = param.getMark();
        List<Integer> markList = new ArrayList<>();
        if ( mark != 1){
            markList.add(0);
            markList.add(1);
        }else{
            markList.add(1);
        }
        param.setMarkList(markList);
        IPage<VideoEquipmentInfo> result;
        if (param.getLevel().equals("1")){
            result= videoAlarmDao.selectVideoInfoBySpaceType(resultPage,param);
        }else if (param.getLevel().equals("2")){
            result=videoAlarmDao.selectVideoInfoBySpace(resultPage,param);
        }else{
            result=videoAlarmDao.selectVideoInfoByMonitor(resultPage,param);
        }
        return result;
    }

    @Override
    public IPage<VideoEquipmentInfo> selectSpaceList(Page<VideoEquipmentInfo> resultPage, Integer mark, String monitorId) {
        List<Integer> markList = new ArrayList<>();
        if ( mark != 1){
            markList.add(0);
            markList.add(1);
        }else{
            markList.add(1);
        }
        return this.baseMapper.selectBySpaceList(resultPage,markList,monitorId);
    }

    @Override
    public List<VideoEquipmentInfo> selectList(int i, String childrenOrgId) {
        //根据粮库id获取前6个视频通道id
        return this.baseMapper.selectListSpace(i,childrenOrgId);
    }
}
