/*
 * Decompiled with CFR 0.152.
 */
package com.testor.biz.sys.dict.data.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.biz.sys.dict.DictEnumCode;
import com.testor.biz.sys.dict.data.model.domain.SysDictData;
import com.testor.biz.sys.dict.data.model.dto.SysDictDataComplexResponse;
import com.testor.biz.sys.dict.data.model.dto.SysDictDataListResponse;
import com.testor.biz.sys.dict.data.model.dto.SysDictDataParam;
import com.testor.biz.sys.dict.data.model.dto.SysDictDataRequest;
import com.testor.biz.sys.dict.data.model.dto.SysDictDataResponse;
import com.testor.biz.sys.dict.data.model.dto.SysDictDelParam;
import com.testor.biz.sys.dict.data.service.SysDictDataService;
import com.testor.biz.sys.dict.type.model.domain.SysDictType;
import com.testor.biz.sys.dict.type.service.SysDictTypeService;
import com.testor.biz.util.CacheDicUtils;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="SysDictData", tags={"SysDictData \u5b57\u5178\u6570\u636e"})
@RequestMapping(value={"/dict/data"})
public class SysDictDataController
extends SuperController {
    private static final Logger log = LoggerFactory.getLogger(SysDictDataController.class);
    @Autowired
    private SysDictDataService sysDictDataService;
    @Autowired
    private SysDictTypeService sysDictTypeService;

    @ApiOperation(value="\u65b0\u589e\u5b57\u5178\u6570\u636e\u952e\u503c", notes="\u65b0\u589e\u5b57\u5178\u6570\u636e\u952e\u503c Add SysDictData")
    @PostMapping(value={"/add"})
    public BaseResponse<SysDictDataResponse> addEntity(@RequestBody SysDictDataRequest addRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)addRequest)) {
            if (StringHelper.isEmpty((CharSequence)addRequest.getDictId())) {
                throw new ApiException(DictEnumCode.UN_DICT_TYPE.transform());
            }
            int counter = this.sysDictDataService.count((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().ne((Object)"status", (Object)"1")).eq((Object)"dict_id", (Object)addRequest.getDictId())).and(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)i.eq((Object)"dict_key", (Object)addRequest.getDictKey());
            }));
            if (counter > 0) {
                throw new ApiException(DictEnumCode.DICT_DATA_EXISTED.transform());
            }
            if (StringHelper.isEmpty((CharSequence)addRequest.getParentId())) {
                addRequest.setParentId("0");
            }
            addRequest.setDictDataId(IdHelper.getId32bit());
            SysDictData data = (SysDictData)((Object)BeanHelper.beanToBean((Object)addRequest, SysDictData.class));
            data.setParentIds(this.queryParentsIds(addRequest.getParentId()));
            boolean save = this.sysDictDataService.save((Object)data);
            if (save) {
                SysDictType sysDictType = (SysDictType)((Object)this.sysDictTypeService.getById((Serializable)((Object)addRequest.getDictId())));
                CacheDicUtils.set(sysDictType.getDictType(), data.getDictKey(), data.getDictValue());
            }
            baseResponse.setData((Object)SysDictDataResponse.builder().dictDataId(data.getDictDataId()).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u4fee\u6539\u5b57\u5178\u6570\u636e\u952e\u503c", notes="\u4fee\u6539\u5b57\u5178\u6570\u636e\u952e\u503c Update SysDictData by Id")
    @PutMapping(value={"/update"})
    public BaseResponse<SysDictDataResponse> updateEntity(@RequestBody SysDictDataRequest updateRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)updateRequest) && StringHelper.isNotEmpty((CharSequence)updateRequest.getDictDataId())) {
            boolean result;
            if (StringHelper.isEmpty((CharSequence)updateRequest.getDictId())) {
                throw new ApiException(DictEnumCode.UN_DICT_TYPE.transform());
            }
            int counter = this.sysDictDataService.count((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().ne((Object)"status", (Object)"1")).eq((Object)"dict_id", (Object)updateRequest.getDictId())).ne((Object)"dict_data_id", (Object)updateRequest.getDictDataId())).and(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)i.eq((Object)"dict_key", (Object)updateRequest.getDictKey());
            }));
            if (counter > 0) {
                throw new ApiException(DictEnumCode.DICT_DATA_EXISTED.transform());
            }
            SysDictData data = (SysDictData)((Object)BeanHelper.beanToBean((Object)updateRequest, SysDictData.class));
            SysDictData oldData = (SysDictData)((Object)this.sysDictDataService.getById((Serializable)((Object)updateRequest.getDictDataId())));
            if (StringHelper.isNotEmpty((CharSequence)updateRequest.getParentId()) && oldData.getParentId().equals(updateRequest.getParentId())) {
                String newParentIds = this.queryParentsIds(updateRequest.getParentId());
                data.setParentIds(newParentIds);
                List<SysDictData> subDictData = this.getAllSubDictData(updateRequest.getDictDataId());
                for (SysDictData sysDictData1 : subDictData) {
                    String newIds = this.replaceParentIds(sysDictData1.getParentIds(), newParentIds, updateRequest.getDictId());
                    if (StringHelper.isNotEmpty((CharSequence)newIds)) {
                        sysDictData1.setParentIds(newIds);
                        continue;
                    }
                    log.error("Area Parents Id update Failed - Dict id:" + updateRequest.getParentId() + ", related sub Area: " + sysDictData1.getDictId());
                    throw new ApiException(DictEnumCode.UPDATE_SUB_DICT_TYPE_ERROR.transform());
                }
                this.sysDictDataService.updateBatchById(subDictData);
            }
            if (result = this.sysDictDataService.updateById((Object)data)) {
                SysDictType sysDictType = (SysDictType)((Object)this.sysDictTypeService.getById((Serializable)((Object)updateRequest.getDictId())));
                CacheDicUtils.set(sysDictType.getDictType(), data.getDictKey(), data.getDictValue());
            }
            baseResponse.setData((Object)SysDictDataResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u5220\u9664\u5b57\u5178\u6570\u636e\u952e\u503c", notes="\u5220\u9664\u5b57\u5178\u6570\u636e\u952e\u503c delete SysDictData by Id")
    @PutMapping(value={"/delete"})
    public BaseResponse<SysDictDataResponse> deleteEntity(@RequestBody SysDictDelParam dictDataId) {
        BaseResponse baseResponse = new BaseResponse();
        if (StringHelper.isNotEmpty((CharSequence)dictDataId.getDictDataId())) {
            SysDictData data = new SysDictData();
            data.setDictDataId(dictDataId.getDictDataId());
            data.setStatus("1");
            List parentAreaList = this.sysDictDataService.list((Wrapper)new QueryWrapper().lambda().like(SysDictData::getParentIds, (Object)dictDataId.getDictDataId()));
            this.sysDictDataService.updateBatchById(parentAreaList.stream().peek(dictData -> dictData.setStatus("1")).collect(Collectors.toList()));
            boolean result = this.sysDictDataService.updateById((Object)data);
            baseResponse.setData((Object)SysDictDataResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5b57\u5178\u6570\u636e", notes="\u6279\u91cf\u5220\u9664\u5b57\u5178\u6570\u636e delete dict data by batch Id")
    @PutMapping(value={"/batch_delete"})
    public BaseResponse<SysDictDataResponse> deleteEntityBatch(@RequestBody SysDictDelParam dictDataIds) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)dictDataIds) && !dictDataIds.getDictDataIds().isEmpty()) {
            List sysDictDataList = dictDataIds.getDictDataIds().stream().map(sysDictDataId -> ((SysDictData.SysDictDataBuilder)SysDictData.builder().dictDataId((String)sysDictDataId).status("1")).build()).collect(Collectors.toList());
            for (String dictDataId : dictDataIds.getDictDataIds()) {
                List<SysDictData> subDictData = this.getAllSubDictData(dictDataId);
                for (SysDictData sysDictData : subDictData) {
                    sysDictData.setStatus("1");
                }
                sysDictDataList.addAll(subDictData);
            }
            boolean result = this.sysDictDataService.updateBatchById(sysDictDataList);
            baseResponse.setData((Object)SysDictDataResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6\u5b57\u5178\u6570\u636e\u5217\u8868", notes="\u83b7\u53d6\u5b57\u5178\u6570\u636e\u5217\u8868 List SysDictData")
    @GetMapping(value={"/list"})
    public BaseResponse<BaseResponseList<SysDictDataListResponse>> listAllEntity(SysDictDataParam param) {
        if (StringHelper.isEmpty((CharSequence)param.getDictId())) {
            throw new ApiException(DictEnumCode.UN_DICT_TYPE.transform());
        }
        BaseResponse baseResponse = new BaseResponse();
        QueryWrapper<SysDictData> queryWrapper = this.createQuery(param);
        BaseResponseList baseResponseList = new BaseResponseList();
        List resultList = this.sysDictDataService.list((Wrapper)queryWrapper).stream().map(e -> (SysDictDataListResponse)e.beanToBean(SysDictDataListResponse.class)).collect(Collectors.toList());
        baseResponseList.setData(resultList);
        baseResponseList.setTotal((long)resultList.size());
        baseResponse.setData((Object)baseResponseList);
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6\u5b57\u5178\u6570\u636e\u8be6\u7ec6\u4fe1\u606f", notes="\u83b7\u53d6\u5b57\u5178\u6570\u636e\u8be6\u7ec6\u4fe1\u606f Get SysDictData By Id")
    @GetMapping(value={"/get"})
    public BaseResponse<SysDictDataResponse> getById(String dictDataId, String dictId, String dictKey) {
        BaseResponse baseResponse = new BaseResponse();
        if (StringHelper.isNotEmpty((CharSequence)dictDataId)) {
            SysDictData data = (SysDictData)((Object)this.sysDictDataService.getById((Serializable)((Object)dictDataId)));
            baseResponse.setData(BeanHelper.beanToBean((Object)((Object)data), SysDictDataResponse.class));
        } else if (StringHelper.isNotEmpty((CharSequence)dictId) && StringHelper.isNotEmpty((CharSequence)dictKey)) {
            SysDictData data = (SysDictData)((Object)this.sysDictDataService.getOne((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"dict_id", (Object)dictId)).eq((Object)"dict_key", (Object)dictKey)).ne((Object)"status", (Object)"1")).last("LIMIT 1")));
            baseResponse.setData(BeanHelper.beanToBean((Object)((Object)data), SysDictDataResponse.class));
        }
        return baseResponse;
    }

    @ApiOperation(value="\u6839\u636e\u5b57\u5178\u7f16\u7801dictType \u53ca \u5b57\u5178\u503cdictKey \u83b7\u53d6\u5b57\u5178\u9879", notes="\u83b7\u53d6\u5b57\u5178\u6570\u636e\u8be6\u7ec6\u4fe1\u606f Get SysDictData By Id")
    @GetMapping(value={"/getDictType"})
    public BaseResponse<SysDictDataResponse> getDictTypeDetail(String dictDataId, String dictType, String dictKey) {
        BaseResponse baseResponse = new BaseResponse();
        if (StringHelper.isNotEmpty((CharSequence)dictDataId)) {
            SysDictData data = (SysDictData)((Object)this.sysDictDataService.getById((Serializable)((Object)dictDataId)));
            baseResponse.setData(BeanHelper.beanToBean((Object)((Object)data), SysDictDataResponse.class));
        } else if (StringHelper.isNotEmpty((CharSequence)dictType) && StringHelper.isNotEmpty((CharSequence)dictKey)) {
            SysDictType one = (SysDictType)((Object)this.sysDictTypeService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"dict_type", (Object)dictType)).ne((Object)"status", (Object)"1")));
            SysDictData data = null;
            if (ObjectHelper.isNotEmpty((Object)((Object)one))) {
                String dictId = one.getDictId();
                data = (SysDictData)((Object)this.sysDictDataService.getOne((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"dict_id", (Object)dictId)).eq((Object)"dict_key", (Object)dictKey)).ne((Object)"status", (Object)"1")).last("LIMIT 1")));
            }
            if (ObjectHelper.isNotEmpty(data)) {
                baseResponse.setData(BeanHelper.beanToBean(data, SysDictDataResponse.class));
            }
        }
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6\u76f4\u63a5\u4e0b\u7ea7\u5b57\u5178\u6570\u636e\u5217\u8868,\u5206\u9875", notes="List SysDictData with Page")
    @GetMapping(value={"/sub_list"})
    public BaseResponse<BaseResponseList<SysDictDataListResponse>> listEntity(SysDictDataParam param) {
        if (StringHelper.isEmpty((CharSequence)param.getDictId())) {
            throw new ApiException(DictEnumCode.UN_DICT_TYPE.transform());
        }
        BaseResponse baseResponse = new BaseResponse();
        Long page = StringHelper.isEmpty((CharSequence)param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit = StringHelper.isEmpty((CharSequence)param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page resultPage = new Page(page.longValue(), limit.longValue());
        QueryWrapper<SysDictData> queryWrapper = this.createQuery(param);
        if (StringHelper.isNotEmpty((CharSequence)param.getDictDataId())) {
            queryWrapper.eq((Object)"parent_id", (Object)param.getDictDataId());
        } else {
            queryWrapper.eq((Object)"parent_id", (Object)"0");
        }
        if (StringHelper.isNotEmpty((CharSequence)param.getDictValue())) {
            queryWrapper.like((Object)"dict_value", (Object)param.getDictValue());
        }
        Page resultList = (Page)this.sysDictDataService.page((IPage)resultPage, (Wrapper)queryWrapper);
        BaseResponseList baseResponseList = new BaseResponseList();
        baseResponseList.setData(resultList.getRecords().stream().map(e -> (SysDictDataListResponse)e.beanToBean(SysDictDataListResponse.class)).collect(Collectors.toList()));
        baseResponseList.setTotal(resultList.getTotal());
        baseResponse.setData((Object)baseResponseList);
        return baseResponse;
    }

    @ApiOperation(value="\u6839\u636e\u5b57\u5178\u7c7b\u578b\u83b7\u53d6\u5b57\u5178\u6570\u636e\u5217\u8868", notes="\u6839\u636e\u5b57\u5178\u7c7b\u578b\u83b7\u53d6\u5b57\u5178\u6570\u636e\u5217\u8868 List SysDictData by sys dict type")
    @GetMapping(value={"/list_by_type"})
    public BaseResponse<SysDictDataComplexResponse> listDataByType(SysDictDataRequest param) {
        if (StringHelper.isEmpty((CharSequence)param.getDictType())) {
            throw new ApiException(DictEnumCode.UN_DICT_TYPE_PARAM.transform());
        }
        SysDictType sysDictType = (SysDictType)((Object)this.sysDictTypeService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysDictType::getDictType, (Object)param.getDictType())).eq(SuperModel::getStatus, (Object)"0")).last("LIMIT 1")));
        if (ObjectHelper.isEmpty((Object)((Object)sysDictType))) {
            throw new ApiException(DictEnumCode.UN_DICT_TYPE.transform());
        }
        SysDictDataParam sysDictDataParam = new SysDictDataParam();
        sysDictDataParam.setDictId(sysDictType.getDictId());
        BaseResponse baseResponse = new BaseResponse();
        sysDictDataParam.setOrderBy("tree_sort");
        sysDictDataParam.setOrderType("asc");
        QueryWrapper<SysDictData> queryWrapper = this.createQuery(sysDictDataParam);
        List<SysDictDataListResponse> resultList = this.sysDictDataService.list((Wrapper)queryWrapper).stream().map(e -> (SysDictDataListResponse)e.beanToBean(SysDictDataListResponse.class)).collect(Collectors.toList());
        SysDictDataComplexResponse baseResponseList = SysDictDataComplexResponse.builder().cascaded(sysDictType.getCascaded()).data(resultList).build();
        baseResponse.setData((Object)baseResponseList);
        return baseResponse;
    }

    private QueryWrapper<SysDictData> createQuery(SysDictDataParam queryParam) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getDictId())) {
            queryWrapper.eq((Object)"dict_id", (Object)queryParam.getDictId());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getStatus())) {
            queryWrapper.eq((Object)"status", (Object)queryParam.getStatus());
        } else {
            queryWrapper.ne((Object)"status", (Object)"1");
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getOrderBy())) {
            if (StringHelper.isNotEmpty((CharSequence)queryParam.getOrderType()) && "asc".equals(queryParam.getOrderType())) {
                queryWrapper.orderByAsc((Object)queryParam.getOrderBy());
            } else {
                queryWrapper.orderByDesc((Object)queryParam.getOrderBy());
            }
        } else {
            queryWrapper.orderByDesc((Object)"tree_sort");
        }
        return queryWrapper;
    }

    private String queryParentsIds(String pid) {
        String pids = pid;
        if ("0".equals(pid)) {
            return pids + ",";
        }
        pid = ((SysDictData)((Object)this.sysDictDataService.getById((Serializable)((Object)pid)))).getParentIds();
        pids = pid + pids + ",";
        return pids;
    }

    private List<SysDictData> getAllSubDictData(String dictDataId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.like((Object)"parent_ids", (Object)dictDataId);
        queryWrapper.ne((Object)"status", (Object)"1");
        return this.sysDictDataService.list((Wrapper)queryWrapper);
    }

    private String replaceParentIds(String oldIds, String newIds, String id) {
        String[] splited = oldIds.split("," + id + ",");
        newIds = splited.length == BizConstants.PARENTS_ID_SPLIT_END ? newIds + id + "," : (splited.length == BizConstants.PARENTS_ID_SPLIT_LENGTH ? newIds + id + "," + splited[1] : "");
        return newIds;
    }
}

