/*
 * Decompiled with CFR 0.152.
 */
package com.testor.biz.sys.org.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.testor.biz.excel.model.ImportCheckResult;
import com.testor.biz.excel.model.ImportError;
import com.testor.biz.excel.service.ImportCheckService;
import com.testor.biz.sys.org.OrgEnumCode;
import com.testor.biz.sys.org.model.domain.SysOrg;
import com.testor.biz.sys.org.model.dto.OrgImport;
import com.testor.biz.sys.org.service.SysOrgService;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class OrgExcelImport
implements ImportCheckService<OrgImport> {
    @Autowired
    private SysOrgService sysOrgService;

    @Override
    public ImportCheckResult<OrgImport> doImportData(Map<String, OrgImport> insertMap, boolean insertTrigger) {
        ArrayList<OrgImport> successData = new ArrayList<OrgImport>();
        ArrayList errorData = new ArrayList();
        TreeMap<String, OrgImport> orderMap = new TreeMap<String, OrgImport>(insertMap);
        ArrayList insertData = new ArrayList();
        for (int i = 0; i < insertMap.keySet().size() + 1; ++i) {
            OrgImport orgImport = orderMap.get(String.valueOf(i));
            if (ObjectHelper.isEmpty((Object)orgImport)) continue;
            orgImport.setOrgName(orgImport.getOrgName().trim());
            String checkResult = this.checkImportData(orgImport);
            if (StringHelper.isNotEmpty((CharSequence)checkResult)) {
                ImportError<OrgImport> importError = ImportError.builder().errorMsg(checkResult).lineNumber(i).data(orgImport).build();
                errorData.add(importError);
                continue;
            }
            successData.add(orgImport);
            this.sysOrgService.save((Object)this.converter(orgImport));
        }
        return new ImportCheckResult<OrgImport>(successData, errorData);
    }

    private String checkImportData(OrgImport data) {
        List sysOrgs;
        StringBuilder result = new StringBuilder();
        List sysOrgList = this.sysOrgService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"org_code", (Object)data.getOrgCode())).ne((Object)"status", (Object)"1"));
        if (!ObjectUtils.isEmpty((Object)sysOrgList)) {
            result.append(OrgEnumCode.ORG_CODE_ALREADY_EXISTS.msg());
        }
        if (!ObjectUtils.isEmpty((Object)(sysOrgs = this.sysOrgService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"org_name", (Object)data.getOrgName())).eq((Object)"parent_id", (Object)data.getParentId())).ne((Object)"status", (Object)"1"))))) {
            result.append(OrgEnumCode.ORG_NAME_ALREADY_EXISTS.msg());
        }
        return result.toString();
    }

    private SysOrg converter(OrgImport orgImport) {
        SysOrg sysOrg = (SysOrg)((Object)BeanHelper.beanToBean((Object)orgImport, SysOrg.class));
        String parentId = orgImport.getParentId();
        if (!StringHelper.isEmpty((CharSequence)parentId) && !"0".equals(parentId)) {
            SysOrg parentOrg = (SysOrg)((Object)this.sysOrgService.getById((Serializable)((Object)parentId)));
            sysOrg.setParentIds(parentOrg.getParentIds() + "," + parentOrg.getOrgId());
        } else {
            sysOrg.setParentId("0");
            sysOrg.setParentIds("0");
        }
        return sysOrg;
    }
}

