/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.backend.admin.apis.biz.gen.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.admin.apis.biz.gen.domain.GenTable;
import com.tongtech.tfw.backend.admin.apis.biz.gen.domain.GenTableColumn;
import com.tongtech.tfw.backend.admin.apis.biz.gen.domain.dto.GenColumnListParam;
import com.tongtech.tfw.backend.admin.apis.biz.gen.domain.dto.GenTableDelParam;
import com.tongtech.tfw.backend.admin.apis.biz.gen.service.IGenTableColumnService;
import com.tongtech.tfw.backend.admin.apis.biz.gen.service.IGenTableService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.io.IoHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tool/gen"})
@Api(value="Code Generator", tags={"CodeGen \u4ee3\u7801\u751f\u6210"})
public class GenController
extends SuperController {
    @Autowired
    private IGenTableService genTableService;
    @Autowired
    private IGenTableColumnService genTableColumnService;

    @ApiOperation(value="\u67e5\u8be2\u4ee3\u7801\u751f\u6210\u5217\u8868", notes="\u67e5\u8be2\u4ee3\u7801\u751f\u6210\u5217\u8868 Gen Table List")
    @GetMapping(value={"/list"})
    public BaseResponse<BaseResponseList<GenTable>> genList(GenTable genTable) {
        BaseResponse baseResponse = new BaseResponse();
        Long page = StringHelper.isEmpty((CharSequence)genTable.getPage()) ? BizConstants.PAGE : Long.valueOf(genTable.getPage());
        Long limit = StringHelper.isEmpty((CharSequence)genTable.getLimit()) ? BizConstants.LIMIT : Long.valueOf(genTable.getLimit());
        Page resultPage = new Page(page.longValue(), limit.longValue());
        IPage<GenTable> resultList = this.genTableService.selectGenTableList((IPage<GenTable>)resultPage, genTable);
        BaseResponseList baseResponseList = new BaseResponseList();
        baseResponseList.setData(resultList.getRecords());
        baseResponseList.setTotal(resultList.getTotal());
        baseResponse.setData((Object)baseResponseList);
        return baseResponse;
    }

    @ApiOperation(value="\u67e5\u8be2\u4ee3\u7801\u751f\u6210\u5355\u8868", notes="\u67e5\u8be2\u4ee3\u7801\u751f\u6210\u5355\u8868 Gen Table Single")
    @GetMapping(value={"/get"})
    public BaseResponse<Map<String, Object>> getInfo(Long tableId) {
        BaseResponse response = new BaseResponse();
        GenTable table = this.genTableService.selectGenTableById(tableId);
        IPage<GenTableColumn> resultList = this.genTableColumnService.selectGenTableColumnListByTableId((IPage<GenTableColumn>)new Page(1L, 100L), tableId);
        List list = resultList.getRecords();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("info", table);
        map.put("rows", list);
        response.setData(map);
        return response;
    }

    @ApiOperation(value="\u67e5\u8be2\u6570\u636e\u5e93\u73b0\u6709\u8868", notes="\u67e5\u8be2\u6570\u636e\u5e93\u73b0\u6709\u8868 list all DB tables")
    @GetMapping(value={"/db/list"})
    public BaseResponse<BaseResponseList<GenTable>> dataList(GenTable genTable) {
        BaseResponse baseResponse = new BaseResponse();
        Long page = StringHelper.isEmpty((CharSequence)genTable.getPage()) ? BizConstants.PAGE : Long.valueOf(genTable.getPage());
        Long limit = StringHelper.isEmpty((CharSequence)genTable.getLimit()) ? BizConstants.LIMIT : Long.valueOf(genTable.getLimit());
        Page resultPage = new Page(page.longValue(), limit.longValue());
        IPage<GenTable> resultList = this.genTableService.selectDbTableList((IPage<GenTable>)resultPage, genTable);
        BaseResponseList baseResponseList = new BaseResponseList();
        baseResponseList.setData(resultList.getRecords());
        baseResponseList.setTotal(resultList.getTotal());
        baseResponse.setData((Object)baseResponseList);
        return baseResponse;
    }

    @ApiOperation(value="\u67e5\u8be2\u6307\u5b9a\u8868\u5b57\u6bb5", notes="\u67e5\u8be2\u6307\u5b9a\u8868\u5b57\u6bb5 List Table Columns")
    @GetMapping(value={"/column"})
    public BaseResponse<BaseResponseList<GenTableColumn>> columnList(GenColumnListParam param) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)param.getTableId())) {
            Long page = StringHelper.isEmpty((CharSequence)param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
            Long limit = StringHelper.isEmpty((CharSequence)param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
            Page resultPage = new Page(page.longValue(), limit.longValue());
            IPage<GenTableColumn> resultList = this.genTableColumnService.selectGenTableColumnListByTableId((IPage<GenTableColumn>)resultPage, param.getTableId());
            BaseResponseList baseResponseList = new BaseResponseList();
            baseResponseList.setData(resultList.getRecords());
            baseResponseList.setTotal(resultList.getTotal());
            baseResponse.setData((Object)baseResponseList);
        }
        return baseResponse;
    }

    @ApiOperation(value="\u5bfc\u5165\u8868\u7ed3\u6784\uff08\u4fdd\u5b58\uff09", notes="\u5bfc\u5165\u8868\u7ed3\u6784\uff08\u4fdd\u5b58\uff09 Import Table into Gen")
    @GetMapping(value={"/importTable"})
    public BaseResponse<String> importTableSave(String tables) {
        String[] tableNames = TypeHelper.toStrArray((String)tables);
        List<GenTable> tableList = this.genTableService.selectDbTableListByNames(tableNames);
        this.genTableService.importGenTable(tableList, this.getUserId());
        return BaseResponse.success();
    }

    @ApiOperation(value="\u4fee\u6539\u4fdd\u5b58\u4ee3\u7801\u751f\u6210\u4e1a\u52a1", notes="\u4fee\u6539\u4fdd\u5b58\u4ee3\u7801\u751f\u6210\u4e1a\u52a1 Edit Gen Table")
    @PutMapping(value={"/update"})
    public BaseResponse<String> editSave(@Validated @RequestBody GenTable genTable) {
        this.genTableService.validateEdit(genTable);
        this.genTableService.updateGenTable(genTable);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u5220\u9664\u4ee3\u7801\u751f\u6210", notes="\u5220\u9664\u4ee3\u7801\u751f\u6210 Delete Gen Table")
    @PutMapping(value={"/delete"})
    public BaseResponse<String> remove(@RequestBody GenTableDelParam genTableDelParam) {
        if (ObjectHelper.isNotEmpty((Object)genTableDelParam) && !genTableDelParam.getTableIds().isEmpty()) {
            Long[] tableIds = genTableDelParam.getTableIds().toArray(new Long[genTableDelParam.getTableIds().size()]);
            this.genTableService.deleteGenTableByIds(tableIds);
        }
        return BaseResponse.success();
    }

    @ApiOperation(value="\u9884\u89c8\u4ee3\u7801", notes="\u9884\u89c8\u4ee3\u7801 View Code")
    @GetMapping(value={"/preview"})
    public BaseResponse<Map<String, String>> preview(Long tableId) {
        BaseResponse response = new BaseResponse();
        Map<String, String> dataMap = this.genTableService.previewCode(tableId);
        response.setData(dataMap);
        return response;
    }

    @ApiOperation(value="\u751f\u6210\u4ee3\u7801", notes="\u751f\u6210\u4ee3\u7801 Download Code")
    @GetMapping(value={"/genCode"})
    public void genCode(HttpServletResponse response, String tableName) throws IOException {
        byte[] data = this.genTableService.generatorCode(tableName);
        this.genCode(response, data);
    }

    @ApiOperation(value="\u6279\u91cf\u751f\u6210\u4ee3\u7801", notes="\u6279\u91cf\u751f\u6210\u4ee3\u7801 Download Code multi")
    @GetMapping(value={"/batchGenCode"})
    public void batchGenCode(HttpServletResponse response, String tables) throws IOException {
        String[] tableNames = TypeHelper.toStrArray((String)tables);
        byte[] data = this.genTableService.generatorCode(tableNames);
        this.genCode(response, data);
    }

    private void genCode(HttpServletResponse response, byte[] data) throws IOException {
        response.reset();
        response.addHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.setHeader("Content-Disposition", "attachment; filename=\"tong-framework.zip\"");
        response.addHeader("Content-Length", "" + data.length);
        response.setContentType("application/octet-stream; charset=UTF-8");
        IoHelper.write((OutputStream)response.getOutputStream(), (boolean)true, (byte[])data);
    }
}

