/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.connector.http2;

import com.tongweb.connector.http2.AbstractNonZeroStream;
import com.tongweb.connector.http2.ConnectionException;
import com.tongweb.connector.http2.Http2Exception;
import com.tongweb.connector.http2.StreamStateMachine;
import java.nio.ByteBuffer;

class RecycledStream
extends AbstractNonZeroStream {
    private final String connectionId;
    private int remainingFlowControlWindow;

    RecycledStream(String connectionId, Integer identifier, StreamStateMachine state, int remainingFlowControlWindow) {
        super(identifier, state);
        this.connectionId = connectionId;
        this.remainingFlowControlWindow = remainingFlowControlWindow;
    }

    @Override
    String getConnectionId() {
        return this.connectionId;
    }

    @Override
    void incrementWindowSize(int increment) throws Http2Exception {
    }

    @Override
    void receivedData(int payloadSize) throws ConnectionException {
        this.remainingFlowControlWindow -= payloadSize;
    }

    @Override
    ByteBuffer getInputByteBuffer(boolean create) {
        if (this.remainingFlowControlWindow < 0) {
            return ZERO_LENGTH_BYTEBUFFER;
        }
        return null;
    }
}

