/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.filters;

import com.tongweb.juli.logging.Log;
import com.tongweb.web.util.IntrospectionUtils;
import com.tongweb.web.util.res.StringManager;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;

public abstract class FilterBase
implements Filter {
    protected static final StringManager sm = StringManager.getManager(FilterBase.class);

    protected abstract Log getLogger();

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        Enumeration<String> paramNames = filterConfig.getInitParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = paramNames.nextElement();
            if (IntrospectionUtils.setProperty(this, paramName, filterConfig.getInitParameter(paramName))) continue;
            String msg = sm.getString("filterbase.noSuchProperty", paramName, this.getClass().getName());
            if (this.isConfigProblemFatal()) {
                throw new ServletException(msg);
            }
            this.getLogger().warn(msg);
        }
    }

    protected boolean isConfigProblemFatal() {
        return false;
    }
}

