/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.dv2.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.CollectionHelper;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.datetime.DatetimeHelper;
import com.tongtech.tfw.dv2.VisualEnumCode;
import com.tongtech.tfw.dv2.model.domain.BladeVisual;
import com.tongtech.tfw.dv2.model.domain.BladeVisualCategory;
import com.tongtech.tfw.dv2.model.domain.BladeVisualConfig;
import com.tongtech.tfw.dv2.model.dto.BladeVisualDelParam;
import com.tongtech.tfw.dv2.model.dto.BladeVisualParam;
import com.tongtech.tfw.dv2.model.dto.VisualDTO;
import com.tongtech.tfw.dv2.model.dto.VisualFileDTO;
import com.tongtech.tfw.dv2.service.BladeVisualCategoryService;
import com.tongtech.tfw.dv2.service.BladeVisualConfigService;
import com.tongtech.tfw.dv2.service.BladeVisualService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/visual/visual"})
@Api(value="BladeVisual", tags={"\u53ef\u89c6\u5316"})
public class BladeVisualController
extends SuperController {
    private static final Logger log = LoggerFactory.getLogger(BladeVisualController.class);
    @Autowired
    private BladeVisualService bladeVisualService;
    @Autowired
    private BladeVisualConfigService bladeVisualConfigService;
    @Autowired
    private BladeVisualCategoryService bladeVisualCategoryService;
    @Value(value="${dataview.file}")
    private String fileRootPath;

    @ApiOperation(value="\u65b0\u589e \u53ef\u89c6\u5316", notes="Add BladeVisual")
    @PostMapping(value={"/save"})
    public BaseResponse<BladeVisual> addEntity(@RequestBody VisualDTO addRequest) {
        VisualDTO save;
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)addRequest) && ObjectHelper.isNotEmpty((Object)(save = this.bladeVisualService.saveComb(addRequest, this.getUserId())))) {
            BladeVisual newEntity = new BladeVisual();
            newEntity.setId(save.getVisual().getId());
            baseResponse.setData((Object)newEntity);
        }
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6 \u53ef\u89c6\u5316 ", notes="Get BladeVisual By Id")
    @GetMapping(value={"/detail"})
    public BaseResponse<VisualDTO> getById(String id) {
        BaseResponse baseResponse = new BaseResponse();
        if (StringHelper.isNotEmpty((CharSequence)id)) {
            BladeVisual data = (BladeVisual)this.bladeVisualService.getById((Serializable)((Object)id));
            BladeVisualConfig dataViewConfig = (BladeVisualConfig)this.bladeVisualConfigService.getOne((Wrapper)new QueryWrapper().lambda().eq(BladeVisualConfig::getVisualId, (Object)id));
            VisualDTO dto = new VisualDTO();
            dto.setVisual(data);
            dto.setConfig(dataViewConfig);
            baseResponse.setData((Object)dto);
        }
        return baseResponse;
    }

    @ApiOperation(value="\u4fee\u6539 \u53ef\u89c6\u5316 ", notes="Update BladeVisual By Id")
    @PutMapping(value={"/update"})
    public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody VisualDTO updateRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)updateRequest)) {
            boolean result = this.bladeVisualService.updateComb(updateRequest, this.getUserId());
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u5220\u9664 \u53ef\u89c6\u5316 ", notes="delete BladeVisual By Id")
    @PutMapping(value={"/delete"})
    public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody BladeVisualDelParam deleteRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)deleteRequest) && StringHelper.isNotEmpty((CharSequence)deleteRequest.getId())) {
            BladeVisual data = new BladeVisual();
            data.setId(deleteRequest.getId());
            data.setStatus("1");
            boolean result = this.bladeVisualService.updateById(data);
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u53ef\u89c6\u5316", notes="delete BladeVisual by batch Id")
    @PutMapping(value={"/batch_delete"})
    public BaseResponse<BizGeneralResponse> deleteEntityBatch(@RequestBody BladeVisualDelParam deleteRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)deleteRequest) && !deleteRequest.getIds().isEmpty()) {
            ArrayList<BladeVisual> bladeVisualList = new ArrayList<BladeVisual>();
            for (String id : deleteRequest.getIds()) {
                BladeVisual data = new BladeVisual();
                data.setId(id);
                data.setStatus("1");
                bladeVisualList.add(data);
            }
            boolean result = this.bladeVisualService.updateBatchById(bladeVisualList);
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @PostMapping(value={"/remove"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u53ef\u89c6\u5316", notes="delete BladeVisual by batch Id")
    public BaseResponse<BizGeneralResponse> remove(@RequestParam String ids) {
        BaseResponse baseResponse = new BaseResponse();
        if (StringHelper.isNotBlank((CharSequence)ids)) {
            List idList = CollectionHelper.arrayToList((Object)StringHelper.split((String)ids, (String)","));
            ArrayList<BladeVisual> deleteList = new ArrayList<BladeVisual>(idList.size());
            for (String id : idList) {
                BladeVisual bladeVisual = new BladeVisual();
                bladeVisual.setId(id);
                bladeVisual.setStatus("1");
                deleteList.add(bladeVisual);
            }
            boolean result = this.bladeVisualService.updateBatchById(deleteList);
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @PostMapping(value={"/copy"})
    @ApiOperation(value="\u590d\u5236", notes="copy BladeVisual by Id")
    public BaseResponse<BizGeneralResponse> copy(@RequestParam String id) {
        BaseResponse baseResponse = new BaseResponse();
        if (StringHelper.isNotBlank((CharSequence)id)) {
            String result = this.bladeVisualService.copyDataView(id, this.getUserId());
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6 \u53ef\u89c6\u5316 \u5206\u9875\u5217\u8868", notes="List BladeVisual with page")
    @GetMapping(value={"/list"})
    public BaseResponse<BaseResponseList<BladeVisual>> listEntity(BladeVisualParam param) {
        BaseResponse baseResponse = new BaseResponse();
        Long page = StringHelper.isEmpty((CharSequence)param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit = StringHelper.isEmpty((CharSequence)param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page resultPage = new Page(page.longValue(), limit.longValue());
        QueryWrapper<BladeVisual> queryWrapper = this.createQuery(param);
        Page resultList = (Page)this.bladeVisualService.page((IPage)resultPage, (Wrapper)queryWrapper);
        BaseResponseList baseResponseList = new BaseResponseList();
        baseResponseList.setData(resultList.getRecords());
        baseResponseList.setTotal(resultList.getTotal());
        baseResponse.setData((Object)baseResponseList);
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6 \u53ef\u89c6\u5316 \u5217\u8868", notes="List BladeVisual all")
    @GetMapping(value={"/datas"})
    public BaseResponse<BaseResponseList<BladeVisual>> listAllEntity(BladeVisualParam param) {
        BaseResponse baseResponse = new BaseResponse();
        QueryWrapper<BladeVisual> queryWrapper = this.createQuery(param);
        List resultList = this.bladeVisualService.list((Wrapper)queryWrapper);
        BaseResponseList baseResponseList = new BaseResponseList();
        baseResponseList.setData(resultList);
        baseResponseList.setTotal((long)resultList.size());
        baseResponse.setData((Object)baseResponseList);
        return baseResponse;
    }

    @ApiOperation(value="\u4e0a\u4f20\u6587\u4ef6", notes="\u4e0a\u4f20\u6587\u4ef6 Upload File")
    @PostMapping(value={"/put-file"})
    public BaseResponse<VisualFileDTO> upload(@RequestParam MultipartFile file) {
        BaseResponse baseResponse = new BaseResponse();
        if (file.isEmpty()) {
            throw new ApiException(VisualEnumCode.NOT_FOUND.transform());
        }
        String fileName = file.getOriginalFilename();
        int beginIndex = fileName.indexOf(".") + 1;
        String ext = StringHelper.substring((String)fileName, (int)beginIndex, (int)fileName.length());
        String filePath = DatetimeHelper.getDateTime8Length();
        String saveName = IdHelper.getId32bit();
        try {
            File path = new File(this.fileRootPath + filePath);
            if (!path.exists()) {
                path.mkdirs();
            }
            File dest = new File(new File(this.fileRootPath + filePath).getAbsolutePath() + File.separator + saveName + "." + ext);
            FileCopyUtils.copy((byte[])file.getBytes(), (File)dest);
            log.info("\u4fdd\u5b58\u6210\u529f\uff1aFileId\uff1a" + saveName + ", ext: " + ext + ", path:" + filePath + ", name:" + fileName + ", user: " + this.getUserId());
        }
        catch (IOException e) {
            log.error(e.toString(), (Throwable)e);
            throw new ApiException(VisualEnumCode.IO_FAILD.transform());
        }
        VisualFileDTO newEntity = VisualFileDTO.builder().link(filePath + File.separator + saveName + "." + ext).build();
        baseResponse.setData((Object)newEntity);
        return baseResponse;
    }

    @GetMapping(value={"category"})
    @ApiOperationSupport(order=7)
    @ApiOperation(value="\u83b7\u53d6\u7c7b\u578b")
    public BaseResponse<BaseResponseList<BladeVisualCategory>> category() {
        BaseResponse baseResponse = new BaseResponse();
        List resultList = this.bladeVisualCategoryService.list();
        BaseResponseList baseResponseList = new BaseResponseList();
        baseResponseList.setData(resultList);
        baseResponseList.setTotal((long)resultList.size());
        baseResponse.setData((Object)baseResponseList);
        return baseResponse;
    }

    private QueryWrapper<BladeVisual> createQuery(BladeVisualParam queryParam) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getTitle())) {
            queryWrapper.eq((Object)"title", (Object)queryParam.getTitle());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getBackgroundUrl())) {
            queryWrapper.eq((Object)"background_url", (Object)queryParam.getBackgroundUrl());
        }
        if (ObjectHelper.isNotEmpty((Object)queryParam.getCategory())) {
            queryWrapper.eq((Object)"category", (Object)queryParam.getCategory());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getPassword())) {
            queryWrapper.eq((Object)"password", (Object)queryParam.getPassword());
        }
        if (ObjectHelper.isNotEmpty((Object)queryParam.getCreateUser())) {
            queryWrapper.eq((Object)"create_user", (Object)queryParam.getCreateUser());
        }
        if (ObjectHelper.isNotEmpty((Object)queryParam.getCreateDept())) {
            queryWrapper.eq((Object)"create_dept", (Object)queryParam.getCreateDept());
        }
        if (ObjectHelper.isNotEmpty((Object)queryParam.getCreateTime())) {
            queryWrapper.eq((Object)"create_time", (Object)queryParam.getCreateTime());
        }
        if (ObjectHelper.isNotEmpty((Object)queryParam.getUpdateUser())) {
            queryWrapper.eq((Object)"update_user", (Object)queryParam.getUpdateUser());
        }
        if (ObjectHelper.isNotEmpty((Object)queryParam.getUpdateTime())) {
            queryWrapper.eq((Object)"update_time", (Object)queryParam.getUpdateTime());
        }
        if (ObjectHelper.isNotEmpty((Object)queryParam.getIsDeleted())) {
            queryWrapper.eq((Object)"is_deleted", (Object)queryParam.getIsDeleted());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getStatus())) {
            queryWrapper.eq((Object)"status", (Object)queryParam.getStatus());
        } else {
            queryWrapper.ne((Object)"status", (Object)"1");
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getOrderBy())) {
            if (StringHelper.isNotEmpty((CharSequence)queryParam.getOrderType()) && "asc".equals(queryParam.getOrderType())) {
                queryWrapper.orderByAsc((Object)queryParam.getOrderBy());
            } else {
                queryWrapper.orderByDesc((Object)queryParam.getOrderBy());
            }
        } else {
            queryWrapper.orderByDesc((Object)"update_time");
        }
        return queryWrapper;
    }
}

