/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.backend.core.helper;

import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class CollectionHelper {
    public static boolean isEmpty(Collection coll) {
        return Objects.isNull(coll) || coll.isEmpty();
    }

    public static boolean isNotEmpty(Collection coll) {
        return !CollectionHelper.isEmpty(coll);
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap(16);
    }

    public static <K, V> HashMap<K, V> newHashMap(int initialCapacity) {
        return new HashMap(initialCapacity);
    }

    public static <K, V> HashMap<K, V> newHashMap(Map<? extends K, ? extends V> map) {
        return new HashMap<K, V>(map);
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(Map<? extends K, ? extends V> map) {
        return new LinkedHashMap<K, V>(map);
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentMap() {
        return new ConcurrentHashMap();
    }

    public static <K extends Comparable, V> TreeMap<K, V> newTreeMap() {
        return new TreeMap();
    }

    public static <K, V> TreeMap<K, V> newTreeMap(SortedMap<K, ? extends V> map) {
        return new TreeMap<K, V>(map);
    }

    public static <C, K extends C, V> TreeMap<K, V> newTreeMap(Comparator<C> comparator) {
        return new TreeMap(comparator);
    }

    public static <K extends Enum<K>, V> EnumMap<K, V> newEnumMap(Class<K> type) {
        return new EnumMap(type);
    }

    public static <K extends Enum<K>, V> EnumMap<K, V> newEnumMap(Map<K, ? extends V> map) {
        return new EnumMap<K, V>(map);
    }

    public static <K, V> IdentityHashMap<K, V> newIdentityHashMap() {
        return new IdentityHashMap();
    }

    public static List arrayToList(Object source) {
        return Arrays.asList(ObjectHelper.toObjectArray(source));
    }

    public static Object[] addAll(Object[] array1, Object[] array2) {
        if (array1 == null) {
            return CollectionHelper.clone(array2);
        }
        if (array2 == null) {
            return CollectionHelper.clone(array1);
        }
        Object[] joinedArray = (Object[])Array.newInstance(array1.getClass().getComponentType(), array1.length + array2.length);
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    public static Object[] clone(Object[] array) {
        return array == null ? null : (Object[])array.clone();
    }

    public static long[] clone(long[] array) {
        return array == null ? null : (long[])array.clone();
    }

    public static int[] clone(int[] array) {
        return array == null ? null : (int[])array.clone();
    }

    public static short[] clone(short[] array) {
        return array == null ? null : (short[])array.clone();
    }

    public static char[] clone(char[] array) {
        return array == null ? null : (char[])array.clone();
    }

    public static byte[] clone(byte[] array) {
        return array == null ? null : (byte[])array.clone();
    }

    public static double[] clone(double[] array) {
        return array == null ? null : (double[])array.clone();
    }

    public static float[] clone(float[] array) {
        return array == null ? null : (float[])array.clone();
    }

    public static boolean[] clone(boolean[] array) {
        return array == null ? null : (boolean[])array.clone();
    }
}

