/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.backend.common.models.response;

import com.tongtech.tfw.backend.common.exception.MvcExceptionFormatter;
import com.tongtech.tfw.backend.common.models.response.ResponseInfo;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import java.time.LocalDateTime;
import javax.servlet.http.HttpServletRequest;

public class FailedResponse {
    private final Integer code;
    private final String msg;
    private final String errorMsg;
    private final String info;
    private final LocalDateTime time;

    public static FailedResponse buildFailedResponse(HttpServletRequest request, Exception exception, ResponseInfo failedResponseInfo) {
        FailedResponseBuilder builder = FailedResponse.builder();
        if (ObjectHelper.isNotEmpty((Object)failedResponseInfo)) {
            builder.code(failedResponseInfo.getCode()).msg(failedResponseInfo.getMsg());
        }
        if (ObjectHelper.isNotEmpty((Object)exception)) {
            builder.errorMsg(MvcExceptionFormatter.formatException(exception));
        }
        if (ObjectHelper.isNotEmpty((Object)request)) {
            builder.info((String)request.getAttribute("requestId"));
        }
        builder.time(LocalDateTime.now());
        return builder.build();
    }

    FailedResponse(Integer code, String msg, String errorMsg, String info, LocalDateTime time) {
        this.code = code;
        this.msg = msg;
        this.errorMsg = errorMsg;
        this.info = info;
        this.time = time;
    }

    public static FailedResponseBuilder builder() {
        return new FailedResponseBuilder();
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public String getInfo() {
        return this.info;
    }

    public LocalDateTime getTime() {
        return this.time;
    }

    public String toString() {
        return "FailedResponse(code=" + this.getCode() + ", msg=" + this.getMsg() + ", errorMsg=" + this.getErrorMsg() + ", info=" + this.getInfo() + ", time=" + this.getTime() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FailedResponse)) {
            return false;
        }
        FailedResponse other = (FailedResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        String this$errorMsg = this.getErrorMsg();
        String other$errorMsg = other.getErrorMsg();
        if (this$errorMsg == null ? other$errorMsg != null : !this$errorMsg.equals(other$errorMsg)) {
            return false;
        }
        String this$info = this.getInfo();
        String other$info = other.getInfo();
        if (this$info == null ? other$info != null : !this$info.equals(other$info)) {
            return false;
        }
        LocalDateTime this$time = this.getTime();
        LocalDateTime other$time = other.getTime();
        return !(this$time == null ? other$time != null : !((Object)this$time).equals(other$time));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FailedResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        String $errorMsg = this.getErrorMsg();
        result = result * 59 + ($errorMsg == null ? 43 : $errorMsg.hashCode());
        String $info = this.getInfo();
        result = result * 59 + ($info == null ? 43 : $info.hashCode());
        LocalDateTime $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        return result;
    }

    public static class FailedResponseBuilder {
        private Integer code;
        private String msg;
        private String errorMsg;
        private String info;
        private LocalDateTime time;

        FailedResponseBuilder() {
        }

        public FailedResponseBuilder code(Integer code) {
            this.code = code;
            return this;
        }

        public FailedResponseBuilder msg(String msg) {
            this.msg = msg;
            return this;
        }

        public FailedResponseBuilder errorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
            return this;
        }

        public FailedResponseBuilder info(String info) {
            this.info = info;
            return this;
        }

        public FailedResponseBuilder time(LocalDateTime time) {
            this.time = time;
            return this;
        }

        public FailedResponse build() {
            return new FailedResponse(this.code, this.msg, this.errorMsg, this.info, this.time);
        }

        public String toString() {
            return "FailedResponse.FailedResponseBuilder(code=" + this.code + ", msg=" + this.msg + ", errorMsg=" + this.errorMsg + ", info=" + this.info + ", time=" + this.time + ")";
        }
    }
}

