package com.testor.common.core.enums;

public enum HttpStatusCodeEnum {
    TEST(1000, "EXCEPTION"),
    UNKNOWN(996, "未知错误"),
    OK(200, "请求已成功"),
    CREATED(201, "请求资源已创建"),
    ACCEPTED(202, "服务器已接受请求"),
    NON_AUTHORITATIVE_INFORMATION(203, "请求已处理，非授权信息"),
    NO_CONTENT(204, "请求已处理，无返回"),
    RESET_CONTENT(205, "请求已处理，连接重置"),
    BAD_REQUEST(400, "请求参数错误或不完整"),
    TOKEN_INVALID(401, "认证Token无效"),
    UNAUTHORIZED(401, "请先进行授权认证"),
    FORBIDDEN(403, "无权查看"),
    NOT_FOUND(404, "未找到该资源"),
    METHOD_NOT_ALLOWED(405, "请求方式不支持"),
    NOT_ACCEPTABLE(406, "请求被拒绝"),
    LENGTH_REQUIRED(411, "长度受限"),
    UNSUPPORTED_MEDIA_TYPE(415, "不支持的媒体类型"),
    REQUESTED_RANGE_NOT_SATISFIABLE(416, "不能满足请求的范围"),
    INTERNAL_SERVER_ERROR(500, "接口服务错误"),
    SERVICE_UNAVAILABLE(503, "请求超时"),
    SERVICE_BUSINESS(4302, "业务操作异常");

    private final int code;
    private final String msg;

    private HttpStatusCodeEnum(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public int code() {
        return this.code;
    }

    public String msg() {
        return this.msg;
    }
}