package com.testor.common.constant;

/**
 * 应急预案演练状态
 *
 * @author yizhixiong
 * @date 2022/12/05
 */
public enum RehearsalStatus {

    NOT_START("0", "未开始"),
    WAIT_DISPOSITION("1", "待处置"),
    DISPOSITION_ONGOING("2", "处置中"),
    WAIT_EVALUATE("3", "待评价"),
    COMPLETED("4", "已完成"),
    CLOSE("5", "已关闭"),
    ;

    RehearsalStatus(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    private String code;

    private String msg;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public static RehearsalStatus getRehearsalStatusByCode(String code) {
        RehearsalStatus[] values = values();
        for (RehearsalStatus value : values) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        return null;
    }
    public static RehearsalStatus getRehearsalStatusByMsg(String msg) {
        RehearsalStatus[] values = values();
        for (RehearsalStatus value : values) {
            if (value.getMsg().equals(msg)) {
                return value;
            }
        }
        return null;
    }
}
