package com.testor.ddd.safetyControl.domain.space.entity;

import com.baomidou.mybatisplus.extension.service.IService;
import com.testor.ddd.safetyControl.infrastructure.repository.space.entity.TSafeSpaceTypeDO;
import com.testor.ddd.safetyControl.interfaces.model.dto.space.TSafeSpaceTypeDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.space.TSafeSpaceTypeDTOParam;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.models.supers.SuperService;

import java.util.List;

/**
 *
 * 连接持久化的接口，具体实现类为 infrastructure.repository.impl
 *
 */
public interface TSafeSpaceTypeRepo extends SuperService<TSafeSpaceTypeDO> {

    /**
     * 检测 名称、编码 是否都唯一
     * @param id
     * @param orgId
     * @param name
     * @param code
     * @return true - 唯一； false - 不唯一
     */
    List<TSafeSpaceTypeDTO> checkUniqueness(String id, String orgId, String name, String code);

    int insert(TSafeSpaceTypeDTO spaceTypeDTO);

    int updateById(TSafeSpaceTypeDTO spaceTypeDTO);
    /**
     * 分页查询
     * @param param
     * @return
     */
    BaseResponseList<TSafeSpaceTypeDTO> listPage(TSafeSpaceTypeDTOParam param);

    TSafeSpaceTypeDTO findById(String id);

    List<TSafeSpaceTypeDTO> myList();

    List<TSafeSpaceTypeDO> getListByIds(List<String> spaceTypeIds);
}
