package com.testor.ddd.safetyControl.interfaces.controller;

import com.testor.ddd.safetyControl.application.service.equipmentManage.EquipmentTypeManageService;
import com.testor.ddd.safetyControl.interfaces.model.dto.equipment.TSafeEquipmentTypeDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.equipment.TSafeEquipmentTypeDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.dto.equipment.TSafeEquipmentTypeDelParam;
import com.testor.ddd.safetyControl.interfaces.model.vo.equipment.TSafeEquipmentTypeVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import lombok.extern.slf4j.Slf4j;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperController;

/**
 * 设备系统类型/设备类型Controller
 *
 * @author testor-framework
 * @date 2022-07-02 11:02:02
 */
@RestController
@RequestMapping("/equipment/equipmentType")
@Api(value = "TSafeEquipmentType", tags = "设备系统类型-设备类型")
@Slf4j
public class TSafeEquipmentTypeController extends SuperController
{

    @Autowired
    private EquipmentTypeManageService equipmentTypeManageService;

    /* Generated Method*/
    @ApiOperation(value = "新增、修改设备系统类型/设备类型", notes = "Add TSafeEquipment")
    @PostMapping(value = "/add")
    public BaseResponse addEntity(@RequestBody TSafeEquipmentTypeDTO addRequest) {
        return equipmentTypeManageService.editEquipmentType(addRequest);
    }

    @ApiOperation(value = "删除 设备系统类型/设备类型 ", notes = "delete TSafeEquipment By Id")
    @PutMapping(value = "/delete")
    public BaseResponse deleteEntity(@RequestBody TSafeEquipmentTypeDelParam deleteRequest){
        BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
        if(ObjectHelper.isNotEmpty(deleteRequest)&& StringHelper.isNotEmpty(deleteRequest.getId())){
            baseResponse= equipmentTypeManageService.deleteById(deleteRequest.getType(), deleteRequest.getId());
        }
        return baseResponse;
    }

    @ApiOperation(value = "获取 设备系统类型/设备类型 分页列表", notes = "List TSafeEquipment with page")
    @GetMapping(value = "/list")
    public  BaseResponse<BaseResponseList<TSafeEquipmentTypeVO>>listEntity(TSafeEquipmentTypeDTOParam param){
        BaseResponse<BaseResponseList<TSafeEquipmentTypeVO>>baseResponse=new BaseResponse<>();
        BaseResponseList<TSafeEquipmentTypeVO> resultList= equipmentTypeManageService.listByPage(param);
        baseResponse.setData(resultList);
        return baseResponse;
    }

    @ApiOperation(value = "获取 设备系统类型/设备类型 分页列表(查询设备总数大于0的类型)", notes = "List TSafeEquipment with pages")
    @GetMapping(value = "/listByPages")
    public  BaseResponse<BaseResponseList<TSafeEquipmentTypeVO>>listByPages(TSafeEquipmentTypeDTOParam param){
        BaseResponse<BaseResponseList<TSafeEquipmentTypeVO>>baseResponse=new BaseResponse<>();
        BaseResponseList<TSafeEquipmentTypeVO> resultList= equipmentTypeManageService.listByPages(param);
        baseResponse.setData(resultList);
        return baseResponse;
    }
}
