package com.testor.ddd.safetyControl.interfaces.model.vo.space;

import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.jeecgframework.poi.excel.annotation.Excel;


/**
 * 
 * @author sj
 * @date 2022-06-27 16:56:21
 */
@Data
public class TSafeSpaceVO extends SuperModel
{

  @ApiModelProperty(value = "id")
  private String id;
  /**
   * 组织机构id
   */
  @ApiModelProperty(value = "组织机构id")
  private String orgId;

  @ApiModelProperty(value = "组织机构")
  private String orgName;
  /**
   * 车间/场所类型id
   */
  @ApiModelProperty(value = "车间/场所类型id")
  private String spaceTypeId;

  /**
   * 车间/场所类型id
   */
  @ApiModelProperty(value = "车间/场所类型")
  private String spaceTypeName;

  /**
   * 车间/场所名称id(level=1时，此值位空)
   */
  @ApiModelProperty(value = "车间/场所名称id")
  private String spaceId;

  /**
   * 车间/场所名称id(level=1时，此值位空)
   */
  @ApiModelProperty(value = "车间/场所名称")
  @Excel(name = "车间场所名称",width = 40,mergeVertical=true)
  private String spaceName;

  /**
   * 车间/场所名称id(level=1时，此值位空)
   */
  @ApiModelProperty(value = "车间/场所名称编码")
  private String spaceCode;

  /**
   * 名称
   */
  @ApiModelProperty(value = "名称")
  @Excel(name = "作业区域名称",width = 40)
  private String name;

  /**
   * 编码
   */
  @ApiModelProperty(value = "编码")
  @Excel(name = "作业区域编号",width = 20)
  private String code;
  /**
   * 等级(1-车间场所名称；2-作业区域)
   */
  @ApiModelProperty(value = "等级(1-车间场所名称；2-作业区域)")
  private Integer level;

  @ApiModelProperty(value = "结构名称")
  private String structureName;

}
