package com.testor.module.aptitude.model.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.List;
import com.testor.module.aptitude.model.domain.TPersonAptitude;

/**
 * 人员资质管理 删除参数对象
 *
 * @author testor-framework
 * @date 2022-07-20 18:05:48
 */

@Data
@ApiModel(value = "TPersonAptitude 列表查询参数对象")
@EqualsAndHashCode(callSuper = true)
public class TPersonAptitudeParam extends TPersonAptitude {
	private static final long serialVersionUID = 1L;
	@ApiModelProperty(value = "每页数量")
	private String limit;

	@ApiModelProperty(value = "当前页数")
	private String page;

	@ApiModelProperty(value = "排序字段")
	private String orderBy;

	@ApiModelProperty(value = "排序方式")
	private String orderType;

	@ApiModelProperty(value = "多个资质信息")
	private List<TPersonAptitude> tPersonAptitudes;

	@ApiModelProperty(value = "开始日期")
	private String startData;

	@ApiModelProperty(value = "结束日期")
	private String endData;

	@ApiModelProperty(value = "多个企业信息id")
	private List<String> orgIds ;


}
