package com.testor.module.aptitude.service;


import com.testor.module.aptitude.model.domain.TPersonAptitude;
import com.testor.module.aptitude.model.domain.TPersonAptitudeDto;
import com.testor.module.aptitude.model.dto.DataStatistics;
import com.testor.module.aptitude.model.dto.TPersonAptitudeDelParam;
import com.testor.module.aptitude.model.dto.TPersonAptitudeParam;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperService;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * 人员资质管理Service接口
 * 
 * @author testor-framework
 * @date 2022-07-20 18:05:48
 */
public interface TPersonAptitudeService extends SuperService<TPersonAptitude> {

    BaseResponse<TPersonAptitude> addEntity(TPersonAptitudeParam addRequest)throws Exception;

    BaseResponse<List<TPersonAptitude>> getAptitude(TPersonAptitude addRequest);

    BaseResponse<TPersonAptitudeDto> getByIds(String id);

    BaseResponse<BizGeneralResponse> updateEntity(TPersonAptitude updateRequest)throws Exception;

    BaseResponse<BizGeneralResponse> deleteEntity(TPersonAptitudeDelParam deleteRequest);

    BaseResponse<List<DataStatistics>> AptitudeStatistics(TPersonAptitudeParam addRequest);

    BaseResponse<BizGeneralResponse> AptitudeStatus();

    BaseResponse<BizGeneralResponse> AptitudeExport(MultipartFile file)throws Exception;
}
