package com.testor.module.contractor.ledger.model.domain;

import java.time.LocalDateTime;

import com.testor.common.annotation.Translation;
import com.testor.common.constant.TransConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;


/**
 * 物料台账对象 t_contractor_material
 * 
 * @author testor-framework
 * @date 2024-11-19 10:29:21
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_contractor_material")
@ApiModel(value = "TContractorMaterial对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TContractorMaterial extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * 主键ID
 */
  @ApiModelProperty(value = "主键ID")

  @TableId("id")
  private String id;
/**
 * 物料名称
 */
  @ApiModelProperty(value = "物料名称")

  @TableField("name")
  private String name;

  /**
   * 名称下拉选项值
   */
  @ApiModelProperty(value = "名称下拉选项值")
  @TableField(exist = false)
  private String nameSelect;

/**
 * 类别id（数据字典id）
 */
  @ApiModelProperty(value = "类别id（数据字典id）")

  @TableField("type_id")
  private String typeId;
/**
 * 类别
 */
  @ApiModelProperty(value = "类别")
  @Translation(type = TransConstant.DICT_ID_TO_LABEL,mapper = "typeId")
  @TableField("type")
  private String type;
/**
 * 危险性id（数据字典id）
 */
  @ApiModelProperty(value = "危险性id（数据字典id）")

  @TableField("risk_id")
  private String riskId;
/**
 * 危险性
 */
  @ApiModelProperty(value = "危险性")
  @Translation(type = TransConstant.DICT_ID_TO_LABEL,mapper = "riskId")
  @TableField("risk")
  private String risk;
/**
 * 型号
 */
  @ApiModelProperty(value = "型号")

  @TableField("model")
  private String model;
/**
 * 数量
 */
  @ApiModelProperty(value = "数量" , example = "0")

  @TableField("num")
  private Long num;
/**
 * 用途
 */
  @ApiModelProperty(value = "用途")

  @TableField("purpose")
  private String purpose;
/**
 * 所属企业id
 */
  @ApiModelProperty(value = "所属企业id")

  @TableField("org_id")
  private String orgId;

  public static final String ID ="id";
  public static final String NAME ="name";
  public static final String TYPE_ID ="type_id";
  public static final String TYPE ="type";
  public static final String RISK_ID ="risk_id";
  public static final String RISK ="risk";
  public static final String MODEL ="model";
  public static final String NUM ="num";
  public static final String PURPOSE ="purpose";
  public static final String ORG_ID ="org_id";


}
