package com.testor.module.contractor.manage.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.common.model.UpdateProcessStatusReq;
import com.testor.module.contractor.manage.model.domain.TContractorEvaluate;
import com.testor.module.contractor.manage.model.dto.ContractorEvaluateDto;
import com.testor.module.contractor.manage.model.dto.TContractorEvaluateParam;
import com.tongtech.tfw.backend.common.exception.BusinessException;
import com.tongtech.tfw.backend.common.models.supers.SuperService;

/**
 * 承包商考核评价Service接口
 * 
 * @author testor-framework
 * @date 2024-11-30 15:42:18
 */
public interface TContractorEvaluateService extends SuperService<TContractorEvaluate> {

    Page<ContractorEvaluateDto> pageList(TContractorEvaluateParam param);

    TContractorEvaluate addEntity(TContractorEvaluateParam addRequest);
    boolean updateEntity(TContractorEvaluateParam updateRequest);

    void updateProcessStatus(UpdateProcessStatusReq updateProcessStatusReq) throws Exception;

    void startProcess(TContractorEvaluateParam updateRequest);
    void completeProcess(TContractorEvaluateParam updateRequest);
    
    /**
     * 根据承包商id,查询承包商考核评价记录，如果有则返回，如果没有则返回null
     * @param contractorId 承包商台账id
     * @return
     */
    TContractorEvaluate getByContractorId(String contractorId);

    /**
     * 下一步
     * @param updateRequest
     */
    void nextStep(TContractorEvaluateParam updateRequest);
}
