package com.testor.module.fives.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.math.BigDecimal;


/**
 * 5s工具运用评价对象 t_fives_tool_evaluate
 *
 * @author testor-framework
 * @date 2022-07-21 15:56:53
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_fives_tool_evaluate")
@ApiModel(value = "TFivesToolEvaluate对象", description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TFivesToolEvaluate extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")

    @TableId("id")
    private String id;
    /**
     * 附件上传
     */
    @ApiModelProperty(value = "附件上传")

    @TableField("ref_id")
    private String refId;
    /**
     * 父级ID
     */
    @ApiModelProperty(value = "父级ID")

    @TableField("parent_id")
    private String parentId;
    /**
     * 租户id
     */
    @ApiModelProperty(value = "租户id")

    @TableField("tenant_id")
    private String tenantId;
    /**
     * 流程实例ID
     */
    @ApiModelProperty(value = "流程实例ID")

    @TableField("process_id")
    private String processId;
    /**
     * 流程状态
     */
    @ApiModelProperty(value = "流程状态")

    @TableField("process_status")
    private String processStatus;
    /**
     * 评价用户id
     */
    @ApiModelProperty(value = "评价用户id")

    @TableField("evaluate_use_id")
    private String evaluateUseId;
    /**
     * 工具运用id
     */
    @ApiModelProperty(value = "工具运用id")

    @TableField("tool_use_id")
    private String toolUseId;

    /**
     * 评分
     */
    @ApiModelProperty(value = "评分")

    @TableField("score")
    private BigDecimal score;

    @ApiModelProperty(value = "机构id")

    @TableField("org_id")
    private String orgId;

    @ApiModelProperty(value = "级别")
    @TableField("tree_level")
    private BigDecimal treeLevel;

    public static final String ID = "id";
    public static final String REF_ID = "ref_id";
    public static final String PARENT_ID = "parent_id";
    public static final String TENANT_ID = "tenant_id";
    public static final String PROCESS_ID = "process_id";
    public static final String PROCESS_STATUS = "process_status";
    public static final String EVALUATE_USE_ID = "evaluate_use_id";
    public static final String TOOL_USE_ID = "tool_use_id";
    public static final String ORG_ID = "org_id";
    public static final String TREE_LEVEL = "tree_level";


}
