package com.testor.module.fives.model.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;
import java.util.Date;


/**
 * 5s工具运用焦点课题对象 t_fives_tool_focus
 *
 * @author testor-framework
 * @date 2022-07-21 15:56:54
 */
@Data
@ApiModel(value = "TFivesToolFocusDTO 对象", description = "")
public class TFivesToolFocusDTO {
    private static final long serialVersionUID = 1L;
    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")
    private String id;
    /**
     * 父级ID
     */
    @ApiModelProperty(value = "父级ID")
    private String parentId;
    /**
     * 课程名称
     */
    @ApiModelProperty(value = "课程名称")
    private String courseName;
    /**
     * 课题所属部门（当前登录用户所属企业部门）
     */
    @ApiModelProperty(value = "课题所属部门（当前登录用户所属企业部门）")
    private String courseSection;
    /**
     * 课题负责人
     */
    @ApiModelProperty(value = "课题负责人")
    private String coursePrincipal;
    /**
     * 团队人数
     */
    @ApiModelProperty(value = "团队人数", example = "0")
    private Long teamSize;
    /**
     * 课题方向（字典配置）
     */
    @ApiModelProperty(value = "课题方向（字典配置）")
    private String courseDirection;
    /**
     * 改善对象
     */
    @ApiModelProperty(value = "改善对象")
    private String focusObj;
    /**
     * 计划开始时间
     */
    @ApiModelProperty(value = "计划开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date beginDate;
    /**
     * 计划结束时间
     */
    @ApiModelProperty(value = "计划结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date endDate;
    /**
     * 推进理由
     */
    @ApiModelProperty(value = "推进理由")
    private String boostReason;
    /**
     * 重点推进内容
     */
    @ApiModelProperty(value = "重点推进内容")
    private String boostContent;
    /**
     * 预期目标
     */
    @ApiModelProperty(value = "预期目标")
    private String expectTarget;
    /**
     * 最终结果
     */
    @ApiModelProperty(value = "最终结果")
    private String lastResult;

    @ApiModelProperty(value = "流程实例id")
    private String processId;

}
