package com.testor.module.globalAlarm.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;


/**
 * 全局报警对象 t_global_alarm
 * 
 * @author testor-framework
 * @date 2023-02-08 11:09:19
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_global_alarm")
@ApiModel(value = "TGlobalAlarm对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TGlobalAlarm extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * 主键ID
 */
  @ApiModelProperty(value = "主键ID")

  @TableId("id")
  private String id;
/**
 * 组织机构id
 */
  @ApiModelProperty(value = "组织机构id")

  @TableField("org_id")
  private String orgId;
/**
 * 组织机构名称
 */
  @ApiModelProperty(value = "组织机构名称")

  @TableField("org_name")
  private String orgName;
/**
 * 报警位置
 */
  @ApiModelProperty(value = "报警位置")

  @TableField("region")
  private String region;
/**
 * 报警类型
 */
  @ApiModelProperty(value = "报警类型")

  @TableField("event_type")
  private String eventType;
/**
 * 报警截图
 */
  @ApiModelProperty(value = "报警截图")

  @TableField("alarm_picture")
  private String alarmPicture;


  @TableField(exist = false)
  private String[] alarmPictures;
/**
 * 报警时间
 */
  @ApiModelProperty(value = "报警时间")

  @TableField("sj_date")
  private String sjDate;
/**
 * 处置状态
 */
  @ApiModelProperty(value = "处置状态 0 待处理 1 重复报警 2 误报警 3已转隐患 ")

  @TableField("dispose_status")
  private String disposeStatus;
/**
 * 事件等级
 */
  @ApiModelProperty(value = "事件等级")

  @TableField("event_level")
  private String eventLevel;
/**
 * 摄像头国际id
 */
  @ApiModelProperty(value = "摄像头国际id")

  @TableField("gb_id")
  private String gbId;
/**
 * 事件源
 */
  @ApiModelProperty(value = "事件源")

  @TableField("event_source")
  private String eventSource;
/**
 * 机构名称
 */
  @ApiModelProperty(value = "机构名称")

  @TableField("jg_name")
  private String jgName;
/**
 * 信息编码
 */
  @ApiModelProperty(value = "信息编码")

  @TableField("bm")
  private String bm;
/**
 * 文件分组id
 */
  @ApiModelProperty(value = "文件分组id")

  @TableField("group_id")
  private String groupId;
/**
 * 关联ID
 */
  @ApiModelProperty(value = "关联ID")

  @TableField("ref_id")
  private String refId;
/**
 * 父级ID
 */
  @ApiModelProperty(value = "父级ID")

  @TableField("parent_id")
  private String parentId;
/**
 * 租户id
 */
  @ApiModelProperty(value = "租户id")

  @TableField("tenant_id")
  private String tenantId;
/**
 * 流程实例ID
 */
  @ApiModelProperty(value = "流程实例ID")

  @TableField("process_id")
  private String processId;
/**
 * 流程状态
 */
  @ApiModelProperty(value = "流程状态")

  @TableField("process_status")
  private String processStatus;

  public static final String ID ="id";
  public static final String ORG_ID ="org_id";
  public static final String ORG_NAME ="org_name";
  public static final String REGION ="region";
  public static final String EVENT_TYPE ="event_type";
  public static final String ALARM_PICTURE ="alarm_picture";
  public static final String SJ_DATE ="sj_date";
  public static final String DISPOSE_STATUS ="dispose_status";
  public static final String EVENT_LEVEL ="event_level";
  public static final String GB_ID ="gb_id";
  public static final String EVENT_SOURCE ="event_source";
  public static final String JG_NAME ="jg_name";
  public static final String BM ="bm";
  public static final String GROUP_ID ="group_id";
  public static final String REF_ID ="ref_id";
  public static final String PARENT_ID ="parent_id";
  public static final String TENANT_ID ="tenant_id";
  public static final String PROCESS_ID ="process_id";
  public static final String PROCESS_STATUS ="process_status";


}
