package com.testor.module.hazard.controller;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import com.testor.module.hazard.model.dto.THazardLicenseDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import lombok.extern.slf4j.Slf4j;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;

import com.testor.module.hazard.model.domain.THazardLicense;
import com.testor.module.hazard.model.dto.THazardLicenseParam;
import com.testor.module.hazard.model.dto.THazardLicenseDelParam;
import com.testor.module.hazard.service.THazardLicenseService;

/**
 * 危险作业-许可证信息Controller
 *
 * @author testor-framework
 * @date 2024-12-31 17:24:34
 */
@RestController
@RequestMapping("/module/license")
@Api(value = "THazardLicense", tags = "危险作业-许可证信息")
@Slf4j
public class THazardLicenseController extends SuperController
{
    @Autowired
    private THazardLicenseService tHazardLicenseService;

    /* Generated Method*/
	@ApiOperation(value = "新增 危险作业-许可证信息", notes = "Add THazardLicense")
	@PostMapping(value = "/saveOrUpdate")
	public BaseResponse<THazardLicense>saveOrUpdateEntity(@RequestBody THazardLicenseDTO addRequest) {
		BaseResponse<THazardLicense> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(addRequest)){
			THazardLicense result= tHazardLicenseService.saveOrUpdateEntity(addRequest);
			baseResponse.setData(result);
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 危险作业-许可证信息 ", notes = "Get THazardLicense By Id")
	@GetMapping(value = "/get")
	public BaseResponse<THazardLicenseDTO> getById(String planId){
		BaseResponse<THazardLicenseDTO> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(planId)){
			// TODO 按需求添加业务异常判断
            THazardLicenseDTO data= tHazardLicenseService.getDetailedById(planId);
			baseResponse.setData(data);
		}
		return baseResponse;
	}

	@ApiOperation(value = "修改 危险作业-许可证信息 ", notes = "Update THazardLicense By Id")
	@PutMapping(value = "/update")
	public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody THazardLicense updateRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            THazardLicense data=BeanHelper.beanToBean(updateRequest, THazardLicense.class);
			boolean result= tHazardLicenseService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "删除 危险作业-许可证信息 ", notes = "delete THazardLicense By Id")
	@PutMapping(value = "/delete")
	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody THazardLicenseDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            THazardLicense data= new THazardLicense();
			data.setId(deleteRequest.getId());
			data.setStatus(BizConstants.STATUS_DELETE);
			boolean result= tHazardLicenseService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "批量删除危险作业-许可证信息", notes = "delete THazardLicense by batch Id")
	@PutMapping(value = "/batch_delete")
	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
			@RequestBody THazardLicenseDelParam deleteRequest) {
		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
			List<THazardLicense> tHazardLicenseList = new ArrayList<>();
            for(String id: deleteRequest.getIds()){
                THazardLicense data= new THazardLicense();
				data.setId(id);
				data.setStatus(BizConstants.STATUS_DELETE);
                tHazardLicenseList.add(data);
			}
			boolean result = tHazardLicenseService.updateBatchById(tHazardLicenseList);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 危险作业-许可证信息 分页列表", notes = "List THazardLicense with page")
	@GetMapping(value = "/list")
	public  BaseResponse<BaseResponseList<THazardLicense>>listEntity(THazardLicenseParam param){
		BaseResponse<BaseResponseList<THazardLicense>>baseResponse=new BaseResponse<>();
		Long page=
				StringHelper.isEmpty(param.getPage())?BizConstants.PAGE:Long.valueOf(param.getPage());
		Long limit=
				StringHelper.isEmpty(param.getLimit())?BizConstants.LIMIT:Long.valueOf(param.getLimit());
		Page<THazardLicense> resultPage=new Page<>(page,limit);
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<THazardLicense> queryWrapper=this.createQuery(param);
		Page<THazardLicense> resultList= tHazardLicenseService.page(resultPage,queryWrapper);
		BaseResponseList<THazardLicense> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 危险作业-许可证信息 列表", notes = "List THazardLicense all")
	@GetMapping(value = "/datas")
	public  BaseResponse<BaseResponseList<THazardLicense>>listAllEntity(THazardLicenseParam param){
		BaseResponse<BaseResponseList<THazardLicense>>baseResponse=new BaseResponse<>();
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<THazardLicense> queryWrapper=this.createQuery(param);
		List<THazardLicense> resultList=tHazardLicenseService.list(queryWrapper);
		BaseResponseList<THazardLicense> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

    /* Private Methods */
	/**
     * 列表查询条件及查询参数
     */
	private QueryWrapper<THazardLicense> createQuery(THazardLicenseParam queryParam){
		QueryWrapper<THazardLicense> queryWrapper=new QueryWrapper<>();
		if(StringHelper.isNotEmpty(queryParam.getPlanId())){
			queryWrapper.eq(THazardLicense.PLAN_ID,queryParam.getPlanId());
		}
		if(StringHelper.isNotEmpty(queryParam.getWorkType())){
			queryWrapper.eq(THazardLicense.WORK_TYPE,queryParam.getWorkType());
		}
		if(StringHelper.isNotEmpty(queryParam.getSpecificTask())){
			queryWrapper.eq(THazardLicense.SPECIFIC_TASK,queryParam.getSpecificTask());
		}
		if(StringHelper.isNotEmpty(queryParam.getInvolvesOtherHazardousWork())){
			queryWrapper.eq(THazardLicense.INVOLVES_OTHER_HAZARDOUS_WORK,queryParam.getInvolvesOtherHazardousWork());
		}
		if(StringHelper.isNotEmpty(queryParam.getElevatedEquipmentName())){
			queryWrapper.like(THazardLicense.ELEVATED_EQUIPMENT_NAME,queryParam.getElevatedEquipmentName());
		}
		if(StringHelper.isNotEmpty(queryParam.getSuspensionLocation())){
			queryWrapper.eq(THazardLicense.SUSPENSION_LOCATION,queryParam.getSuspensionLocation());
		}
		if(StringHelper.isNotEmpty(queryParam.getWorkRisk())){
			queryWrapper.eq(THazardLicense.WORK_RISK,queryParam.getWorkRisk());
		}
		if(StringHelper.isNotEmpty(queryParam.getFacilityUnit())){
			queryWrapper.eq(THazardLicense.FACILITY_UNIT,queryParam.getFacilityUnit());
		}
		if(StringHelper.isNotEmpty(queryParam.getFacilityName())){
			queryWrapper.like(THazardLicense.FACILITY_NAME,queryParam.getFacilityName());
		}
		if(StringHelper.isNotEmpty(queryParam.getOriginalMedium())){
			queryWrapper.eq(THazardLicense.ORIGINAL_MEDIUM,queryParam.getOriginalMedium());
		}
		if(StringHelper.isNotEmpty(queryParam.getPrimaryHazardFactors())){
			queryWrapper.eq(THazardLicense.PRIMARY_HAZARD_FACTORS,queryParam.getPrimaryHazardFactors());
		}
		if (StringHelper.isNotEmpty(queryParam.getStatus())) {
			queryWrapper.eq(THazardLicense.STATUS, queryParam.getStatus());
		} else {
			queryWrapper.ne(THazardLicense.STATUS, BizConstants.STATUS_DELETE);
		}
		if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
			if(StringHelper.isNotEmpty(queryParam.getOrderType())
					&&BizConstants.ASC.equals(queryParam.getOrderType())){
				queryWrapper.orderByAsc(queryParam.getOrderBy());
			}else{
				queryWrapper.orderByDesc(queryParam.getOrderBy());
			}
		}else{
			queryWrapper.orderByDesc(THazardLicense.UPDATE_DATE);
		}
		return queryWrapper;
	}
}
