package com.testor.module.hazard.controller;

import com.testor.module.hazard.model.domain.THazardWorkPlan;
import com.testor.module.hazard.model.domain.THazardWorkPlanExpiredLog;
import com.testor.module.hazard.service.THazardWorkPlanExpiredLogService;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/hazard/expiredLog")
@Api(value = "THazardWorkPlanExpiredLog", tags = "危险作业计划过期日志")
@Slf4j
public class THazardWorkPlanExpiredLogController {

    @Autowired
    private THazardWorkPlanExpiredLogService hazardWorkPlanExpiredLogService;

    @ApiOperation(value = "危险作业计划自动过期", notes = "危险作业计划自动过期")
    @GetMapping(value = "/refreshSwitch")
    public BaseResponse refreshSwitch() {
        BaseResponse baseResponse=new BaseResponse<>();
        hazardWorkPlanExpiredLogService.refreshSwitch();
        baseResponse.setData(true);
        baseResponse.setMsg("操作成功");
        return baseResponse;
    }

    @ApiOperation(value = "危险作业三天内未完成自动过期", notes = "危险作业三天内未完成自动过期")
    @GetMapping(value = "/refreshSwitch1")
    public BaseResponse refreshSwitch1() {
        BaseResponse baseResponse=new BaseResponse<>();
        hazardWorkPlanExpiredLogService.refreshSwitch1();
        baseResponse.setData(true);
        baseResponse.setMsg("操作成功");
        return baseResponse;
    }


    @ApiOperation(value = "根据计划id查询过期日志", notes = "根据计划id查询过期日志")
    @GetMapping(value = "/selectByPlanId")
    public BaseResponse<THazardWorkPlanExpiredLog> selectByPlanId(@RequestParam String planId) {
        BaseResponse<THazardWorkPlanExpiredLog> baseResponse=new BaseResponse<>();
        THazardWorkPlanExpiredLog hazardWorkPlanExpiredLog= hazardWorkPlanExpiredLogService.selectByPlanId(planId);
        baseResponse.setData(hazardWorkPlanExpiredLog);
        return baseResponse;
    }
}
