package com.testor.module.hazard.dao;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.hazard.model.domain.THazardWorkPlanMonitoringRecord;
import com.tongtech.tfw.backend.common.models.supers.SuperDao;
import com.tongtech.tfw.workflow.apis.task.model.dto.TodoTask;
import com.tongtech.tfw.workflow.apis.task.model.dto.TodoTaskSqlParam;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 危险作业监测记录Mapper接口
 *
 * @author testor-framework
 * @date 2025-01-20
 */
public interface THazardWorkPlanMonitoringRecordDao extends SuperDao<THazardWorkPlanMonitoringRecord>
{
    /**
     * 查询待办列表
     */
    IPage<TodoTask> selectToDoList(Page<TodoTask> resultPage, @Param("todo") TodoTaskSqlParam todoTaskSqlParam);

    /**
     * 根据计划ID查询监测记录
     */
    List<THazardWorkPlanMonitoringRecord> selectByPlanId(@Param("planId") String planId);

    /**
     * 根据计划ID列表查询监测记录
     */
    List<THazardWorkPlanMonitoringRecord> selectByPlanIds(@Param("planIds") List<String> planIds);

    /**
     * 批量插入监测记录
     */
    int insertBatch(@Param("list") List<THazardWorkPlanMonitoringRecord> list);
}