package com.testor.module.hazard.dao;

import com.testor.module.hazard.model.domain.TrainExaminationManageRetake;
import com.tongtech.tfw.backend.common.models.supers.SuperDao;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 考试管理—安全培训教育补考表Mapper接口
 *
 * @author testor-framework
 */
public interface TrainExaminationManageRetakeDao extends SuperDao<TrainExaminationManageRetake> {

    /**
     * 根据考试管理ID查询考试管理—安全培训教育补考表
     * @param trainExaminationManageId
     * @return
     */
    @Select("SELECT * FROM t_train_examination_manage_retake WHERE train_examination_manage_id = #{trainExaminationManageId}")
    TrainExaminationManageRetake getByTrainExaminationManageId(@Param("trainExaminationManageId") String trainExaminationManageId);

    @Select("select * from t_train_examination_manage_retake\n" +
            "where train_examination_manage_id in(\n" +
            "select id from t_train_examination_manage\n" +
            "where paper_id =#{paperId}\n" +
            ")")
    List<TrainExaminationManageRetake> getByPaperId(@Param("paperId") String paperId);

}