package com.testor.module.hazard.model.domain;

import java.time.LocalDateTime;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import org.springframework.format.annotation.DateTimeFormat;


/**
 * 危险作业-许可证信息-分析信息对象 t_hazard_license_analysis_info
 * 
 * @author testor-framework
 * @date 2024-12-31 17:57:56
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_hazard_license_analysis_info")
@ApiModel(value = "THazardLicenseAnalysisInfo对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class THazardLicenseAnalysisInfo extends SuperModel
{
    private static final long serialVersionUID = 1L;

  @TableId("id")
  private String id;
/**
 * 许可证id
 */
  @ApiModelProperty(value = "许可证id")

  @TableField("license_id")
  private String licenseId;
/**
 * 分析项目
 */
  @ApiModelProperty(value = "分析项目")

  @TableField("analysis_project")
  private String analysisProject;
/**
 * 测量值


 */
  @ApiModelProperty(value = "测量值")

  @TableField("measurement_value")
  private String measurementValue;
/**
 * 结论


 */
  @ApiModelProperty(value = "结论")

  @TableField("conclusion")
  private String conclusion;
/**
 * 检测人签字
 */
  @ApiModelProperty(value = "检测人签字")

  @TableField("tester_signature")
  private String testerSignature;
/**
 * 测量位置


 */
  @ApiModelProperty(value = "测量位置")

  @TableField("measurement_location")
  private String measurementLocation;
/**
 * 测量时间
 */
  @ApiModelProperty(value = "测量时间")

  @TableField("measurement_time")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date measurementTime;

  public static final String ID ="id";
  public static final String LICENSE_ID ="license_id";
  public static final String ANALYSIS_PROJECT ="analysis_project";
  public static final String MEASUREMENT_VALUE ="measurement_value";
  public static final String CONCLUSION ="conclusion";
  public static final String TESTER_SIGNATURE ="tester_signature";
  public static final String MEASUREMENT_LOCATION ="measurement_location";
  public static final String MEASUREMENT_TIME ="measurement_time";


}
