package com.testor.module.hazard.model.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.testor.biz.file.model.domain.SysFile;
import com.testor.common.annotation.Translation;
import com.testor.common.constant.TransConstant;
import com.testor.module.hazard.model.domain.THazardWorkPlan;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;
import java.util.Map;

@EqualsAndHashCode(callSuper = true)
@Data
public class THazardWorkPlanDTO extends THazardWorkPlan {

    @Translation(type = TransConstant.DICT_ID_TO_LABEL,mapper = "workLevel")
    private String workLevelName;

    @ApiModelProperty(value = "涉及其他危险作业")
    private String involvesOtherHazardousWorkName;

    @ApiModelProperty(value = "相关方作业")
    @Translation(type = TransConstant.DICT_ID_TO_LABEL,mapper = "stakeholderWork")
    private String stakeholderWorkName;

    @Translation(mapper = "isHoliday",other = "0=否,1=是")
    private String isHolidayName;

    @Translation(mapper = "isEscalated",other = "0=否,1=是")
    private String isEscalatedName;

    /**
     * 作业单位
     */
    @ApiModelProperty(value = "作业单位")
    private String workUnitName;

    /**
     * 作业所属单位
     */
    @ApiModelProperty(value = "作业所属单位")
    private String operationUnitName;

    /**
     * 作业主管单位
     */
    @ApiModelProperty(value = "作业主管单位")
    private String workSupervisoryUnitName;

    /**
     * 作业现场负责人
     */
    @ApiModelProperty(value = "作业现场负责人")
    private String workSiteResponsibleName;

    /**
     * 项目负责人
     */
    @ApiModelProperty(value = "项目负责人")
    private String projectLeaderName;

    /**
     * 监护人
     */
    @ApiModelProperty(value = "监护人")
    private String guardianName;

    /**
     * 监督人
     */
    @ApiModelProperty(value = "监督人")
    private String supervisorName;

    /**
     * 作业人
     */
    @ApiModelProperty(value = "作业人")
    private String operatorName;

    /**
     * 风险分析参与人
     */
    @ApiModelProperty(value = "风险分析参与人")
    private String riskAnalysisParticipantName;

    /**
     * 交底人
     */
    @ApiModelProperty(value = "交底人")
    private String discloserName;

    private String createByName;

    private String orgName;

    private String taskId;

    @Translation(type = TransConstant.DICT_TYPE_TO_LABEL,mapper = "buildWorkStatus",other = "dange_work_plan_status")
    private String workStatusName;

    private String buildWorkStatus;

    private Map<String,Object> map;

    @ApiModelProperty("是否现场确认 0=否,1=是")
    private String isOnSiteConfirmation;

    @ApiModelProperty("现场确认提交")
    private String siteConfirmation;

    private List<SysFile> workPlanFileInfo;

    @ApiModelProperty("被交底单位")
    private String disclosedUnitName;

    @ApiModelProperty("检查监督数量")
    private Integer checkCount;

}
