package com.testor.module.hazard.model.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum WorkLevelEnum {

    /**
     * 高度危险
     */
    HIGH_RISK("3", "高度危险"),
    /**
     * 较大危险
     */
    MEDIUM_RISK("2", "较大危险"),
    /**
     * 一般危险
     */
    LOW_RISK("1", "一般危险");

    private final String value; // 风险等级值
    private final String description; // 风险等级描述

    /**
     * 根据状态值获取枚举
     *
     * @param value 风险等级值
     * @return 对应的枚举，如果没有找到则返回 null
     */
    public static WorkLevelEnum fromValue(String value) {
        for (WorkLevelEnum level : values()) {
            if (level.value.equals(value)) {
                return level;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return this.value + " - " + this.description;
    }
}

