package com.testor.module.iam.controller;

import com.testor.module.iam.model.domain.IamMessage;
import com.testor.module.iam.service.IamMessageService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @ClassName: IamNotifyController
 * @Description: IAM实时消息通知
 * @Author: lm
 * @CreateTime: 2023/12/25 10:54
 * @Version: 1.0
 */
@RestController
@RequestMapping("/iam/message")
@Api(value = "IamMessage", tags = "IAM数据推送")
@Slf4j
public class IamMessageController {

    @Autowired
    private IamMessageService iamMessageService;

    @ApiOperation(value = "IAM推送实时消息")
    @PostMapping("push")
    public void push(@RequestBody IamMessage data) {
        iamMessageService.push(data);
    }
}
