package com.testor.module.iam.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.testor.module.iam.dao.IamDepartmentDao;
import com.testor.module.iam.model.domain.IamDepartment;
import com.testor.module.iam.model.domain.IamMessage;
import com.testor.module.iam.model.dto.IamDepartmentQueryDto;
import com.testor.module.iam.service.IamDepartmentService;
import com.testor.module.iam.util.RequestIamUtil;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

/**
 * @ClassName: IamDepartmentServiceImpl
 * @Description: TODO
 * @Author: lm
 * @CreateTime: 2024/1/2 15:55
 * @Version: 1.0
 */
@Service("IamDepartmentServiceImpl")
public class IamDepartmentServiceImpl extends SuperServiceImpl<IamDepartmentDao, IamDepartment> implements IamDepartmentService {

    @Autowired
    private RequestIamUtil requestIamUtil;

    @Autowired
    private IamDepartmentService iamDepartmentService;

    @Override
    public boolean handleMessage(IamMessage iamMessage) {
        boolean flag = false;
        // TODO 看具体推送的消息内容是什么
        switch (iamMessage.getOperateType()){
            case "DELETE":
                iamDepartmentService.remove((Wrapper)(new QueryWrapper()).eq("id", iamMessage.getDataId()));
                flag = true;
                break;
            default:
                IamDepartmentQueryDto dto = new IamDepartmentQueryDto();
                dto.setId(iamMessage.getId());
                List<IamDepartment> list = requestIamUtil.getDepartmentList(dto);
                if (!CollectionUtils.isEmpty(list)){
                    IamDepartment department = list.get(0);
                    department.setUpdateDate(new Date());
                    flag = iamDepartmentService.saveOrUpdate(department);
                }
                break;
        }
        return flag;
    }
}
