package com.testor.module.news.service;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.testor.module.news.model.domain.SysNews;
import com.testor.module.news.model.dto.SysNewsDelParam;
import com.testor.module.news.model.dto.SysNewsParam;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperService;

import java.util.List;

/**
 * 新闻模块Service接口
 * 
 * @author gaobingzhuo@testor.com.cn
 * @date 2022-05-07 14:02:06
 */
public interface SysNewsService extends SuperService<SysNews> {
    //添加新闻
    BaseResponse<SysNews> addEntity(SysNews addRequest) throws Exception;
    //获取新闻
    BaseResponse<SysNews> getByIds(String id) throws Exception;
    //获取新闻修改已读未读状态
    BaseResponse<SysNews> getIsRead(String id) throws Exception;
    //修改新闻
    BaseResponse<BizGeneralResponse> updateEntity(SysNews updateRequest) throws Exception;
    //删除新闻
    BaseResponse<BizGeneralResponse> deleteEntity(SysNewsDelParam deleteRequest)throws Exception;
    //获取新闻分页数据
    BaseResponse<BaseResponseList<SysNews>> listEntity(SysNewsParam param , String startTime , String endTime);

    /**
     * 获取年度新闻数量
     *
     * @return 包含新闻数量的BaseResponse对象
     */
    BaseResponse getCount();

    // 获取已读数据
    IPage<SysNews> getRead(SysNewsParam param, String startTime, String endTime, List<String> list, String loginUserId);

    // 获取未读数据
    IPage<SysNews> getUnRead(SysNewsParam param, String startTime, String endTime, List<String> list, String loginUserId);
}
