package com.testor.module.safeCheck.service;


import com.testor.module.safeCheck.model.domain.TSafeHazardCheckPeople;
import com.testor.module.safeCheck.model.vo.SafeHazardCheckPeopleVO;
import com.tongtech.tfw.backend.common.models.supers.SuperService;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * 巡检人员Service接口
 * 
 * @author testor-framework
 * @date 2022-08-04 11:07:50
 */
public interface TSafeHazardCheckPeopleService extends SuperService<TSafeHazardCheckPeople> {

    /**
     * 根据 巡检计划 编辑 巡检人员（新增、修改、删除的处理）
     * @param planId
     * @param CheckPeopleList
     * @return
     */
    boolean editBatchByPlan(String planId, Long advanceHour, LocalDateTime endDate, List<TSafeHazardCheckPeople> CheckPeopleList);


    /**
     * 根据巡检计划id 查询 巡检人员
     * @param planId
     * @return
     */
    List<TSafeHazardCheckPeople> listByPlan(String planId);

    /**
     * 解析、区分 巡检人员： 新增、 已存在编辑、 删除
     * @param planId 计划id
     * @param CheckPeopleList
     * @return
     */
    Map analysisCheckPeople(String planId, List<TSafeHazardCheckPeople> CheckPeopleList);

    /**
     * @param planId
     * @return
     */
    List<SafeHazardCheckPeopleVO> listVOByPlan(String planId);

    /**
     * 查询指定时间 正在进行的 巡检计划 下的 巡检人员对象信息
     * @param doingDate 指定时间
     * @return
     */
    List<TSafeHazardCheckPeople> listDoingVOByPlanDate(LocalDateTime doingDate);

}
