package com.testor.module.safeCheck.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.testor.module.safeCheck.dao.TSafeCheckPersonDao;
import com.testor.module.safeCheck.model.domain.TSafeCheckOrg;
import com.testor.module.safeCheck.model.domain.TSafeCheckPerson;
import com.testor.module.safeCheck.service.TSafeCheckPersonService;
import org.springframework.stereotype.Service;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Collections;
import java.util.List;

/**
 * 安全检查任务检查人员安排Service业务层处理
 * 
 * @author testor-framework
 * @date 2024-09-03 08:04:18
 */
@Service
public class TSafeCheckPersonServiceImpl extends SuperServiceImpl<TSafeCheckPersonDao, TSafeCheckPerson> implements TSafeCheckPersonService
{
    @Autowired(required = false)
    private TSafeCheckPersonDao tSafeCheckPersonDao;

    @Override
    public List<TSafeCheckPerson> getListByPlanId(String PlanId) {
        return this.list(new LambdaQueryWrapper<TSafeCheckPerson>().eq(TSafeCheckPerson::getPlanId, PlanId));
    }
}
