package com.testor.module.sys.service;

import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.util.Map;

/**
 * @author rsq
 * @program zlmy_boot
 * @return
 **/
public interface AccountLockService {
    /**
     * 获取账号或 IP 的连续错误次数
     *
     * @param accountOrIp 账号或 IP
     * @return 连续错误次数
     */
    int getAttempts(String accountOrIp);

    /**
     * 增加账号或 IP 的连续错误次数
     *
     * @param accountOrIp 账号或 IP
     */
    void increaseAttempts(String accountOrIp);

    /**
     * 重置账号或 IP 的连续错误次数
     *
     * @param accountOrIp 账号或 IP
     */
    void resetAttempts(String accountOrIp);

    /**
     * 解锁账号或 IP 的连续错误次数
     *
     * @param accountOrIp 账号或 IP
     */
    void resetLocked(String accountOrIp);


    /**
     * 检查账号或 IP 是否已被锁定
     *
     * @param accountOrIp 账号或 IP
     * @return 是否已被锁定
     */
    boolean isLocked(String accountOrIp);

    /**
     * 锁定账号或 IP
     *
     * @param accountOrIp 账号或 IP
     * @param duration    锁定时长（单位：分钟）
     */
    void lock(String accountOrIp, int duration);

    /**
     * 生成验证码图片
     * @param response
     * @param session
     * @return
     */
    Map<String, Object> getKaptcha(HttpServletResponse response, HttpSession session);

    /**
     * 校验验证码
     * @param uuid
     * @param text
     * @return
     */
    void checkDefaultKaptcha(String uuid,String text);
}
