package com.testor.module.train.course.model.domain;

import java.time.LocalDateTime;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import org.springframework.format.annotation.DateTimeFormat;


/**
 * 课程小节—安全培训教育对象 t_train_small_node
 *
 * @author testor-framework
 * @date 2022-07-25 18:10:52
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_train_small_node")
@ApiModel(value = "TTrainSmallNode对象", description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TTrainSmallNode extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")

    @TableId("id")
    private String id;
    /**
     * 章节ID
     */
    @ApiModelProperty(value = "章节ID")

    @TableField("section_id")
    private String sectionId;
    /**
     * 父级ID
     */
    @ApiModelProperty(value = "父级ID")

    @TableField("parent_id")
    private String parentId;
    /**
     * 租户id
     */
    @ApiModelProperty(value = "租户id")

    @TableField("tenant_id")
    private String tenantId;
    /**
     * 流程实例ID
     */
    @ApiModelProperty(value = "流程实例ID")

    @TableField("process_id")
    private String processId;
    /**
     * 流程状态
     */
    @ApiModelProperty(value = "流程状态")

    @TableField("process_status")
    private String processStatus;
    /**
     * 小节名称
     */
    @ApiModelProperty(value = "小节名称")

    @TableField("small_node_name")
    private String smallNodeName;
    /**
     * 第几小节
     */
    @ApiModelProperty(value = "第几小节")

    @TableField("several_small_node")
    private String severalSmallNode;
    /**
     * 资料id
     */
    @ApiModelProperty(value = "资料id")

    @TableField("data_id")
    private String dataId;

    /**
     * 一级科目
     */
    @ApiModelProperty(value = "一级科目")

    @TableField("stair_subject")
    private String stairSubject;
    /**
     * 二级科目
     */
    @ApiModelProperty(value = "二级科目")
    @TableField("second_subject")
    private String secondSubject;

    @ApiModelProperty(value = "资料类型  1 视频  2 文档")
    @TableField("data_type")
    private String dataType;

    @ApiModelProperty(value = "0未读 1已读")
    @TableField(exist = false)
    private String readStatus;

    @ApiModelProperty(value = "完成时间")
    @TableField(exist = false)
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date finishTime;


    public static final String ID = "id";
    public static final String SECTION_ID = "section_id";
    public static final String PARENT_ID = "parent_id";
    public static final String TENANT_ID = "tenant_id";
    public static final String PROCESS_ID = "process_id";
    public static final String PROCESS_STATUS = "process_status";
    public static final String SMALL_NODE_NAME = "small_node_name";
    public static final String SEVERAL_SMALL_NODE = "several_small_node";
    public static final String DATA_ID = "data_id";
    public static final String STAIR_SUBJECT = "stair_subject";
    public static final String SECOND_SUBJECT = "second_subject";
    public static final String DATA_TYPE = "data_type";


}
