package com.testor.module.train.project.model.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.Date;

/**
 * 我的培训教育及考试—安全培训教育 删除参数对象
 *
 * @author testor-framework
 * @date 2022-07-28 15:25:02
 */

@Data
public class MyManagement {
	private String id;
	/**
	 * 人员id
	 */
	@ApiModelProperty(value = "人员id")

	private String personId;
	/**
	 * 关联任务id
	 */
	@ApiModelProperty(value = "关联任务id")

	private String taskId;
	/**
	 * 任务类型
	 */
	@ApiModelProperty(value = "任务类型")

	private String taskType;
	/**
	 * 人员归属 本单位/相关方
	 */
	@ApiModelProperty(value = "人员归属 本单位/相关方")

	private String personAffiliation;
	/**
	 * 所属企业
	 */
	@ApiModelProperty(value = "所属企业")

	private String company;

	private String orgName;
	/**
	 * 所属部门
	 */
	@ApiModelProperty(value = "所属部门")

	private String deptName;
	/**
	 * 人员姓名id
	 */
	@ApiModelProperty(value = "人员姓名id")

	private String personNameId;
	/**
	 * 人员姓名
	 */
	@ApiModelProperty(value = "人员姓名")

	private String personName;
	/**
	 * 性别
	 */
	@ApiModelProperty(value = "性别")

	private String sex;
	/**
	 * 学习情况
	 */
	@ApiModelProperty(value = "学习情况(仅当为考试计划时 0 待考试 1 通过 2 未通过)")

	private String percentage;
	/**
	 * 流程实例ID
	 */
	@ApiModelProperty(value = "流程实例ID")

	private String processId;
	/**
	 * 流程状态
	 */
	@ApiModelProperty(value = "流程状态")

	private String processStatus;
	/**
	 * 组织机构id
	 */
	@ApiModelProperty(value = "组织机构id")

	private String orgId;
	/**
	 * 是否考试
	 */
	@ApiModelProperty(value = "是否考试 1 是 0 否")

	private String isAddExam;

	@ApiModelProperty(value = "培训项目名称")
	private String taskName;

	@ApiModelProperty(value = "学习方式 0 线上 1 线下 2 自主 3 (随机考试)线上")
	private String learnWay;

	@ApiModelProperty(value = "当前状态 0 未开始 1 进行中 3 已完成 5 逾期未完成")

	private String currentStatus;

	@ApiModelProperty(value = "计划开始时间")
	@JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date visitStartTime;

	@ApiModelProperty(value = "计划结束时间")
	@JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date visitEndTime;

	@ApiModelProperty(value = "tab切换，1 课程 2 考试 3 练习 ")
	private String tabStatus;

	@ApiModelProperty(value = "试题数量")
	private String testQuestionsNum;

	@ApiModelProperty(value = "试卷id")
	private String testPaperId;

	@ApiModelProperty(value = "考试成绩")
	private String testScore;

	@ApiModelProperty(value = "补考成绩")
	private String repairTest;

	@ApiModelProperty(value = "考试时长")
	private String examDuration;

	@ApiModelProperty(value = "关联我的考试计划")
	private String parentId;



	public static final String PARENT_ID ="parent_id";
	public static final String PERSON_ID ="person_id";
	public static final String TASK_ID ="task_id";
	public static final String TASK_TYPE ="task_type";
	public static final String PERSON_AFFILIATION ="person_affiliation";
	public static final String ORG_NAME ="org_name";
	public static final String DEPT_NAME ="dept_name";
	public static final String PERSON_NAME_ID ="person_name_id";
	public static final String PERSON_NAME ="person_name";
	public static final String SEX ="sex";
	public static final String PERCENTAGE ="percentage";
	public static final String TENANT_ID ="tenant_id";
	public static final String PROCESS_ID ="process_id";
	public static final String PROCESS_STATUS ="process_status";
	public static final String ORG_ID ="org_id";
	public static final String IS_ADD_EXAM ="is_add_exam";
	public static final String TASK_NAME ="task_name";
	public static final String LEARN_WAY ="learn_way";
	public static final String CURRENT_STATUS ="current_status";
	public static final String VISIT_START_TIME ="visit_start_time";
	public static final String VISIT_END_TIME ="visit_end_time";
	public static final String TEST_QUESTIONS_NUM ="test_questions_num";
	public static final String TEST_PAPER_ID ="test_paper_id";
	public static final String TEST_SCORE ="test_score";
	public static final String REPAIR_TEST ="repair_test";
	public static final String EXAM_DURATION ="exam_duration";
}
