package com.testor.module.train.project.model.dto;

import com.testor.module.train.project.model.domain.TTrainEvaluateManage;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 评价管理端——安全培训教育 删除参数对象
 *
 * @author testor-framework
 * @date 2022-08-13 14:16:27
 */

@Data
@ApiModel(value = "TTrainEvaluateManage 列表查询参数对象")
@EqualsAndHashCode(callSuper = true)
public class TTrainEvaluateManageParam extends TTrainEvaluateManage {
	private static final long serialVersionUID = 1L;
	@ApiModelProperty(value = "每页数量")
	private String limit;

	@ApiModelProperty(value = "当前页数")
	private String page;

	@ApiModelProperty(value = "排序字段")
	private String orderBy;

	@ApiModelProperty(value = "排序方式")
	private String orderType;

	@ApiModelProperty("评估类型")
	private List<AssessType> assessTypes;

}
