package com.testor.module.train.project.model.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecgframework.poi.excel.annotation.ExcelCollection;

import java.io.Serializable;
import java.util.List;

/**
 * @title TTrainProjectParamImport
 * @description <TODO description class purpose>
 * @Author: qiao
 * @version:1.0.0
 * @create：5/23/23 2:35 PM
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class TTrainProjectParamImport implements Serializable {


    @Excel(name = "id", isColumnHidden = true, width = 20, needMerge = true)
    private String id;
    /**
     * 培训项目名称
     */
    @ApiModelProperty(value = "培训项目名称")
    @Excel(name = "培训项目名称", width = 20, needMerge = true)
    private String projectName;

    @ApiModelProperty(value = "课程名称")
    @Excel(name = "课程名称", width = 20, needMerge = true)
    private String trainCoursess;


    /**
     * 人员类型
     */
    @ApiModelProperty(value = "人员类型")
    @Excel(name = "人员类型", width = 20, needMerge = true)
    private String visitType;

    @ApiModelProperty(value = "参训单位")
    @Excel(name = "参训单位", width = 20, needMerge = true)
    private String company;

    /**
     * 参训方式
     */
    @ApiModelProperty(value = "参训方式 0 线上 1 线下 2 自主")
    @Excel(name = "参训方式", width = 20, needMerge = true)
    private String visitWay;

    /**
     * 参训方式
     */
    @ApiModelProperty(value = "培训类型 字典 train_type")
    @Excel(name = "培训类型", width = 20, needMerge = true)
    private String trainType;


    /**
     * 参训时间
     */
    @ApiModelProperty(value = "参训时间")
    @Excel(name = "参训时间", width = 20, needMerge = true)
    private String visitTime;


    @ApiModelProperty(value = "参训地点")
    @Excel(name = "参训地点", width = 20, needMerge = true)
    private String visitSite;


    /**
     * 发布单位
     */
    @ApiModelProperty(value = "发布单位")
    @Excel(name = "发布单位", width = 20, needMerge = true)
    private String orgName;
    /**
     * 是否添加考试
     */
    @ApiModelProperty(value = "是否添加考试 1 是 0 否")
    @Excel(name = "是否参加考试", width = 20, needMerge = true)
    private String isAddExam;

    /**
     * 考试名称
     */
    @ApiModelProperty(value = "考试名称")
    @Excel(name = "考试名称", width = 20, needMerge = true)
    private String examName;

    /**
     * 考试类型
     */
    @ApiModelProperty(value = "考试类型")
    @Excel(name = "考试类型", width = 20, needMerge = true)
    private String examType;

    /**
     * 考试开始时间
     */
    @ApiModelProperty(value = "考试时间")
    @Excel(name = "考试时间", width = 20, needMerge = true)
    private String examTime;

    /**
     * 考试时长
     */
    @ApiModelProperty(value = "考试时长")
    @Excel(name = "考试时长", width = 20, needMerge = true)
    private String examDuration;

    /**
     * 考试地点
     */
    @ApiModelProperty(value = "考试地点")
    @Excel(name = "考试地点", width = 20, needMerge = true)
    private String examSite;


    /**
     * 应学人数
     */
    @ApiModelProperty(value = "应学人数")
    @Excel(name = "应学人数", width = 20, needMerge = true)
    private String shouldLearnNumber;
    /**
     * 完成人数
     */
    @ApiModelProperty(value = "完成人数")
    @Excel(name = "完成人数", width = 20, needMerge = true)
    private String finishNumber;
    /**
     * 完成率
     */
    @ApiModelProperty(value = "完成率")
    @Excel(name = "完成率", width = 20, needMerge = true)
    private String percentage;


    @ApiModelProperty(value = "评价人数")
    @Excel(name = "评价人数", width = 20, needMerge = true)
    private String evaluationPerson;

    @ApiModelProperty(value = "评价平均分")
    @Excel(name = "评价平均分", width = 20, needMerge = true)
    private String evaluationAvg;


    @ApiModelProperty(value = "参训对象")
//    @Excel(name = "人员信息", width = 20, needMerge = true)
    @ExcelCollection(name = "人员信息")
    private List<MyManagementExport> myManagements;


}
