package com.testor.module.video.util;

/**
 * @title AutoHeadColumnWidthStyleStrategy
 * @description <TODO 自适应列宽>
 * @Author: qiao
 * @version:1.0.0
 * @create：4/11/23 3:15 PM
 */
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.alibaba.excel.metadata.CellData;
import org.apache.poi.ss.usermodel.Cell;

import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.style.column.AbstractColumnWidthStyleStrategy;

/**
 * Description 自适应列宽
 *
 * @ClassName AutoHeadColumnWidthStyleStrategy
 * @date 2022.10.11 17:50
 */
public class AutoHeadColumnWidthStyleStrategy extends AbstractColumnWidthStyleStrategy {

    private static final int MAX_COLUMN_WIDTH = 255;
    private Map<Integer, Map<Integer, Integer>> CACHE = new HashMap(8);
    // 保底宽度
    private static final int COLUMN_WIDTH = 20;
    public AutoHeadColumnWidthStyleStrategy() {}

    @Override
    protected void setColumnWidth(WriteSheetHolder writeSheetHolder, List<CellData> cellDataList, Cell cell, Head head, Integer integer, Boolean isHead) {
        boolean needSetWidth = isHead && cell.getRowIndex() != 0;
        if (needSetWidth) {
            Map<Integer, Integer> maxColumnWidthMap = CACHE.computeIfAbsent(writeSheetHolder.getSheetNo(), k -> new HashMap<>());

            Integer columnWidth = this.dataLength(cellDataList, cell, isHead);
            if (columnWidth >= 0) {
                if (columnWidth > MAX_COLUMN_WIDTH) {
                    columnWidth = MAX_COLUMN_WIDTH;
                } else {
                    if (columnWidth < COLUMN_WIDTH) {
                        //小于基础跨度的时候略加宽
                        columnWidth = columnWidth +3;
                    }
                }
                Integer maxColumnWidth = maxColumnWidthMap.get(cell.getColumnIndex());
                if (maxColumnWidth == null || columnWidth > maxColumnWidth) {
                    maxColumnWidthMap.put(cell.getColumnIndex(), columnWidth);
                    writeSheetHolder.getSheet().setColumnWidth(cell.getColumnIndex(), columnWidth * 256);
                } else {
                    // 设置表头宽度
                    writeSheetHolder.getSheet().setColumnWidth(cell.getColumnIndex(), columnWidth * 256);
                }
            }
        }
    }

//    @Override
//    protected void setColumnWidth(WriteSheetHolder writeSheetHolder, List<WriteCellData<?>> cellDataList, Cell cell,
//                                  Head head, Integer relativeRowIndex, Boolean isHead) {
//        boolean needSetWidth = isHead && cell.getRowIndex() != 0;
//        if (needSetWidth) {
//            Map<Integer, Integer> maxColumnWidthMap = CACHE.computeIfAbsent(writeSheetHolder.getSheetNo(), k -> new HashMap<>());
//
//            Integer columnWidth = this.dataLength(cellDataList, cell, isHead);
//            if (columnWidth >= 0) {
//                if (columnWidth > MAX_COLUMN_WIDTH) {
//                    columnWidth = MAX_COLUMN_WIDTH;
//                } else {
//                    if (columnWidth < COLUMN_WIDTH) {
//                        //小于基础跨度的时候略加宽
//                        columnWidth = columnWidth +3;
//                    }
//                }
//                Integer maxColumnWidth = maxColumnWidthMap.get(cell.getColumnIndex());
//                if (maxColumnWidth == null || columnWidth > maxColumnWidth) {
//                    maxColumnWidthMap.put(cell.getColumnIndex(), columnWidth);
//                    writeSheetHolder.getSheet().setColumnWidth(cell.getColumnIndex(), columnWidth * 256);
//                } else {
//                    // 设置表头宽度
//                    writeSheetHolder.getSheet().setColumnWidth(cell.getColumnIndex(), columnWidth * 256);
//                }
//            }
//        }
//    }

    private Integer dataLength(List<CellData> cellDataList, Cell cell, Boolean isHead) {
        if (isHead) {
            return cell.getStringCellValue().getBytes().length;
        }
        CellData<?> cellData = cellDataList.get(0);
        CellDataTypeEnum type = cellData.getType();
        if (type == null) {
            return -1;
        }
        switch (type) {
            case STRING:
                return cellData.getStringValue().getBytes().length;
            case BOOLEAN:
                return cellData.getBooleanValue().toString().getBytes().length;
            case NUMBER:
                return cellData.getNumberValue().toString().getBytes().length;
            default:
                return -1;
        }
    }

}
