package com.testor.common.translation.impl;


import com.testor.common.annotation.TranslationType;
import com.testor.common.constant.TransConstant;
import com.testor.common.translation.TranslationInterface;
import com.testor.module.contractor.ledger.model.domain.TContractorInfo;
import com.testor.module.contractor.ledger.model.domain.TContractorLedger;
import com.testor.module.contractor.ledger.service.TContractorInfoService;
import com.testor.module.contractor.ledger.service.TContractorLedgerService;
import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AllArgsConstructor
@TranslationType(type = TransConstant.CONTRACTOR_ID_TO_NAME)
public class ContractorIdTranslationImpl implements TranslationInterface<String> {

    @Autowired
    private TContractorLedgerService tContractorLedgerService;
    @Autowired
    private TContractorInfoService tContractorInfoService;

    @Override
    public String translation(Object key, String other) {
        if (key instanceof String) {
            TContractorLedger tContractorLedger = tContractorLedgerService.getById(key.toString());
            if (tContractorLedger == null){
                return key.toString();
            }else {
                String infoId = tContractorLedger.getInfoId();
                TContractorInfo tContractorInfo = tContractorInfoService.getById(infoId);
                if (tContractorInfo == null){
                    return key.toString();
                }else {
                    return tContractorInfo.getName();
                }
            }
        }
        return key.toString();
    }
}
