package com.testor.ddd.safetyControl.infrastructure.repository.equipment.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.ddd.safetyControl.domain.equipment.entity.TSafeEquipmentRepo;
import com.testor.ddd.safetyControl.infrastructure.repository.equipment.dao.TSafeEquipmentDao;
import com.testor.ddd.safetyControl.infrastructure.repository.equipment.entity.TSafeEquipmentDO;
import com.testor.ddd.safetyControl.interfaces.model.dto.equipment.TSafeEquipmentDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.equipment.TSafeEquipmentDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.vo.equipment.TSafeEquipmentVO;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.models.supers.SuperService;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import org.springframework.stereotype.Service;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 空间设备Service业务层处理
 *
 * @author testor-framework
 * @date 2022-06-27 16:56:19
 */
@Service
public class TSafeEquipmentServiceImpl extends SuperServiceImpl<TSafeEquipmentDao, TSafeEquipmentDO> implements SuperService<TSafeEquipmentDO>, TSafeEquipmentRepo {
    @Autowired(required = false)
    private TSafeEquipmentDao tSafeEquipmentDao;

    @Override
    public List<TSafeEquipmentDTO> checkUniqueness(String id, String equipmentTypeId, String name, String code) {
        String orgId = ContextUtils.getLoginUser().getOrgId();
        LambdaQueryWrapper<TSafeEquipmentDO> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(TSafeEquipmentDO::getEquipmentTypeId, equipmentTypeId)
                .eq(TSafeEquipmentDO::getStatus, BizConstants.STATUS_ENABLE)
                .and(wq -> wq
                        .eq(TSafeEquipmentDO::getName, name)
                        .or()
                        .eq(TSafeEquipmentDO::getCode, code))
                .eq(TSafeEquipmentDO::getOrgId, orgId);
        if (!StrUtil.isBlank(id)) {
            queryWrapper.ne(TSafeEquipmentDO::getId, id);
        }
        List<TSafeEquipmentDO> equipmentDOList = tSafeEquipmentDao.selectList(queryWrapper);
        List<TSafeEquipmentDTO> equipmentDTOList = BeanHelper.listToList(equipmentDOList, TSafeEquipmentDTO.class);
        return equipmentDTOList;
    }

    public int insert(TSafeEquipmentDTO equipmentDTO) {
        TSafeEquipmentDO data = BeanHelper.beanToBean(equipmentDTO, TSafeEquipmentDO.class);
        return tSafeEquipmentDao.insert(data);
    }

    public int updateById(TSafeEquipmentDTO equipmentDTO) {
        TSafeEquipmentDO data = BeanHelper.beanToBean(equipmentDTO, TSafeEquipmentDO.class);
        return tSafeEquipmentDao.updateById(data);
    }


    /**
     * 作业区域分页查询
     *
     * @param param
     * @return
     */
    public BaseResponseList<TSafeEquipmentVO> listPage(TSafeEquipmentDTOParam param) {
        Long page =
                StringHelper.isEmpty(param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit =
                StringHelper.isEmpty(param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page<TSafeEquipmentVO> resultPage = new Page<>(page, limit);
        IPage<TSafeEquipmentVO> iPage = tSafeEquipmentDao.listPage(resultPage, param);

        BaseResponseList<TSafeEquipmentVO> baseResponseList = new BaseResponseList<>();
        baseResponseList.setData(iPage.getRecords());
        baseResponseList.setTotal(iPage.getTotal());
        return baseResponseList;
    }

    public TSafeEquipmentDTO findById(String id) {
        if (StrUtil.isBlank(id)) {
            return null;
        }
        TSafeEquipmentDO equipmentDo = tSafeEquipmentDao.selectById(id);
        TSafeEquipmentDTO equipmentDTO = BeanHelper.beanToBean(equipmentDo, TSafeEquipmentDTO.class);
        return equipmentDTO;
    }

    public TSafeEquipmentVO findDetailById(String id) {
        return tSafeEquipmentDao.findDetailById(id);
    }

    public boolean deleteBySpaceId(String id) {
        UpdateWrapper<TSafeEquipmentDO> updateWrapper = new UpdateWrapper<>();
        updateWrapper.lambda().set(TSafeEquipmentDO::getStatus, BizConstants.STATUS_DELETE)
                .ne(TSafeEquipmentDO::getStatus, BizConstants.STATUS_DELETE)
                .and(wq -> wq
                        .eq(TSafeEquipmentDO::getSpaceId, id)
                        .or()
                        .eq(TSafeEquipmentDO::getSpaceAreaId, id));
        return update(updateWrapper);
    }

    @Override
    public Integer countEquipment(TSafeEquipmentDTOParam param) {
        return tSafeEquipmentDao.countEquipment(param);
    }

    public Integer replaceCode(String typeId, String oldCode, String newCode) {
        return tSafeEquipmentDao.replaceCode(typeId, oldCode, newCode);
    }

    public List<TSafeEquipmentDTO> listAllEntity(TSafeEquipmentDTOParam param) {
        QueryWrapper<TSafeEquipmentDO> queryWrapper = this.createQuery(param);
        List<TSafeEquipmentDO> resultList = list(queryWrapper);
        List<TSafeEquipmentDTO> resultDTOList = BeanHelper.listToList(resultList, TSafeEquipmentDTO.class);
        return resultDTOList;
    }

    /* Private Methods */

    /**
     * 列表查询条件及查询参数
     */
    private QueryWrapper<TSafeEquipmentDO> createQuery(TSafeEquipmentDTOParam queryParam) {
        QueryWrapper<TSafeEquipmentDO> queryWrapper = new QueryWrapper<>();
        if (StringHelper.isNotEmpty(queryParam.getOrgId())) {
            queryWrapper.eq(TSafeEquipmentDO.ORG_ID, queryParam.getOrgId());
        }
        if (StringHelper.isNotEmpty(queryParam.getSysTypeId())) {
            queryWrapper.eq(TSafeEquipmentDO.SYS_TYPE_ID, queryParam.getSysTypeId());
        }
        if (StringHelper.isNotEmpty(queryParam.getEquipmentTypeId())) {
            queryWrapper.eq(TSafeEquipmentDO.EQUIPMENT_TYPE_ID, queryParam.getEquipmentTypeId());
        }
        if (StringHelper.isNotEmpty(queryParam.getName())) {
            queryWrapper.like(TSafeEquipmentDO.NAME, queryParam.getName());
        }
        if (StringHelper.isNotEmpty(queryParam.getCode())) {
            queryWrapper.eq(TSafeEquipmentDO.CODE, queryParam.getCode());
        }
        if (StringHelper.isNotEmpty(queryParam.getSpecification())) {
            queryWrapper.eq(TSafeEquipmentDO.SPECIFICATION, queryParam.getSpecification());
        }
        if (StringHelper.isNotEmpty(queryParam.getSpaceId())) {
            queryWrapper.eq(TSafeEquipmentDO.SPACE_ID, queryParam.getSpaceId());
        }
        if (StringHelper.isNotEmpty(queryParam.getSpaceAreaId())) {
            queryWrapper.eq(TSafeEquipmentDO.SPACE_AREA_ID, queryParam.getSpaceAreaId());
        }
        if (StringHelper.isNotEmpty(queryParam.getManufacturer())) {
            queryWrapper.eq(TSafeEquipmentDO.MANUFACTURER, queryParam.getManufacturer());
        }
        if (StringHelper.isNotEmpty(queryParam.getDes())) {
            queryWrapper.eq(TSafeEquipmentDO.DES, queryParam.getDes());
        }
        if (ObjectHelper.isNotEmpty(queryParam.getValidityDate())) {
            queryWrapper.eq(TSafeEquipmentDO.VALIDITY_DATE, queryParam.getValidityDate());
        }
        if (StringHelper.isNotEmpty(queryParam.getIsSpecial())) {
            queryWrapper.eq(TSafeEquipmentDO.IS_SPECIAL, queryParam.getIsSpecial());
        }
        if (StringHelper.isNotEmpty(queryParam.getStatus())) {
            queryWrapper.eq(TSafeEquipmentDO.STATUS, queryParam.getStatus());
        } else {
            queryWrapper.ne(TSafeEquipmentDO.STATUS, BizConstants.STATUS_DELETE);
        }
        if (StringHelper.isNotEmpty(queryParam.getOrderBy())) {
            if (StringHelper.isNotEmpty(queryParam.getOrderType())
                    && BizConstants.ASC.equals(queryParam.getOrderType())) {
                queryWrapper.orderByAsc(queryParam.getOrderBy());
            } else {
                queryWrapper.orderByDesc(queryParam.getOrderBy());
            }
        } else {
            queryWrapper.orderByDesc(TSafeEquipmentDO.UPDATE_DATE);
        }
        return queryWrapper;
    }

    public boolean saveBatch(List<TSafeEquipmentDTO> equipmentDTOList) {
        List<TSafeEquipmentDO> equipmentDOList = BeanHelper.listToList(equipmentDTOList, TSafeEquipmentDO.class);
        return saveBatch(equipmentDOList);
    }

    /**
     * 设备列表 （安全风险 拉下数据）
     *
     * @param param
     * @return
     */
    public List<TSafeEquipmentVO> listForRisk(TSafeEquipmentDTOParam param) {
        return tSafeEquipmentDao.listForRisk(param);
    }
}
