package com.testor.ddd.safetyControl.infrastructure.repository.riskStatistics.service;

import com.testor.ddd.safetyControl.domain.riskStatistics.entity.RiskStatisticsRepo;
import com.testor.ddd.safetyControl.infrastructure.repository.riskStatistics.dao.RiskStatisticsDao;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskStatistics.RiskStatisticsDTO;
import com.testor.ddd.safetyControl.interfaces.model.vo.riskStatistics.RiskStatisticsNumVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 危险源Service业务层处理
 * 
 * @author testor-framework
 * @date 2022-07-11 10:00:17
 */
@Service
public class RiskStatisticsServiceImpl implements RiskStatisticsRepo

{
    @Autowired(required = false)
    private RiskStatisticsDao riskStatisticsDao;


    @Override
    public List<RiskStatisticsNumVO> statisticsSourceNum(RiskStatisticsDTO param) {
        if(param.getRiskType() != 1 && param.getRiskType() !=2) {
            return null;
        }
        return riskStatisticsDao.statisticsSourceNum(param);
    }

    @Override
    public List<RiskStatisticsNumVO> statisticsSourceNumBySpaceType(RiskStatisticsDTO param) {
        if(param.getRiskType() != 1 && param.getRiskType() !=2) {
            return null;
        }
        return riskStatisticsDao.statisticsSourceNumBySpaceType(param);
    }

    @Override
    public List<RiskStatisticsNumVO> statisticsSourceLevel(RiskStatisticsDTO param) {
        if(param.getRiskType() != 1 && param.getRiskType() !=2) {
            return null;
        }
        if(param.getRiskType() == 1) {
            param.setDictType("inherent_level");
        }
        if(param.getRiskType() == 2) {
            param.setDictType("real_level");
        }
        return riskStatisticsDao.statisticsSourceLevel(param);
    }

    /**
     * 危险源类型统计
     * @param param
     * @return
     */
    public List<RiskStatisticsNumVO> statisticsSourceType(RiskStatisticsDTO param){
        if(param.getRiskType() != 1 && param.getRiskType() !=2) {
            return null;
        }
        return riskStatisticsDao.statisticsSourceType(param);
    }

    @Override
    public List<RiskStatisticsNumVO> statisticsPointNum(RiskStatisticsDTO param) {
        if(param.getRiskType() != 1 && param.getRiskType() !=2) {
            return null;
        }
        return riskStatisticsDao.statisticsPointNum(param);
    }

    @Override
    public List<RiskStatisticsNumVO> statisticsPointNumBySpaceType(RiskStatisticsDTO param) {
        if(param.getRiskType() != 1 && param.getRiskType() !=2) {
            return null;
        }
        return riskStatisticsDao.statisticsPointNumBySpaceType(param);
    }

    @Override
    public List<RiskStatisticsNumVO> statisticsPointLevel(RiskStatisticsDTO param) {
        if(param.getRiskType() != 1 && param.getRiskType() !=2) {
            return null;
        }
        if(param.getRiskType() == 1) {
            param.setDictType("inherent_level");
        }
        if(param.getRiskType() == 2) {
            param.setDictType("real_level");
        }
        return riskStatisticsDao.statisticsPointLevel(param);
    }

    /**
     * 危险源类型统计
     * @param param
     * @return
     */
    public List<RiskStatisticsNumVO> statisticsPointType(RiskStatisticsDTO param){
        if(param.getRiskType() != 1 && param.getRiskType() !=2) {
            return null;
        }
        return riskStatisticsDao.statisticsPointType(param);
    }

}

