package com.testor.module.duty.model.dto;

import com.testor.module.duty.model.domain.TSysDutyLog;
import com.testor.module.duty.model.domain.TSysTaskWork;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 值班日志 删除参数对象
 *
 * @author testor-framework
 * @date 2022-06-08 14:31:30
 */

@Data
@ApiModel(value = "TSysDutyLog 列表查询参数对象")
@EqualsAndHashCode(callSuper = true)
public class TSysDutyLogParam extends TSysDutyLog {
	private static final long serialVersionUID = 1L;
	@ApiModelProperty(value = "每页数量")
	private String limit;

	@ApiModelProperty(value = "当前页数")
	private String page;

	@ApiModelProperty(value = "排序字段")
	private String orderBy;

	@ApiModelProperty(value = "排序方式")
	private String orderType;

//	@ApiModelProperty(value = "班次")
//	private String classes;

	@ApiModelProperty(value = "开始日期")
	private String startDate;

	@ApiModelProperty(value = "结束日期")
	private String endDate;
	@ApiModelProperty(value = "不是危险作业的id")
	private String noRiskJob;
	@ApiModelProperty(value = "作业活动")
	private List<TSysTaskWork> taskWorks ;
	@ApiModelProperty(value = "条件查询多个企业id")
	private List<String> companyIds;
	@ApiModelProperty(value = "班次时间")
	private String classesTime;

}
