package com.testor.module.emergency.service;



import com.baomidou.mybatisplus.core.metadata.IPage;
import com.testor.module.emergency.model.domain.TEmergencyWorkingUser;
import com.testor.module.emergency.model.dto.TEmergencyWorkingUserParam;
import com.tongtech.tfw.backend.common.exception.BusinessException;
import com.tongtech.tfw.backend.common.models.supers.SuperService;

/**
 * 应急救援小组人员Service接口
 * 
 * @author testor-framework
 * @date 2022-11-17 11:52:10
 */
public interface TEmergencyWorkingUserService extends SuperService<TEmergencyWorkingUser> {

    /**
     * 获取用户列表
     *
     * @param tEmergencyWorkingUserParam 用户参数t应急工作
     * @return {@link IPage}
     */
    IPage getUserList(TEmergencyWorkingUserParam tEmergencyWorkingUserParam);

    /**
     * 添加和更新用户
     *
     * @param tEmergencyWorkingUser 用户vo t应急工作
     * @return boolean
     */
    boolean addAndUpdateUser(TEmergencyWorkingUser tEmergencyWorkingUser) throws BusinessException;

}
