package com.testor.module.environment.model.dto;

import com.testor.module.environment.model.domain.TBasicEnvironmentManage;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 环保基本面管理 删除参数对象
 *
 * @author testor-framework
 * @date 2022-09-16 13:37:50
 */

@Data
@ApiModel(value = "TBasicEnvironmentManage 列表查询参数对象")
@EqualsAndHashCode(callSuper = true)
public class TBasicEnvironmentManageParam extends TBasicEnvironmentManage {
	private static final long serialVersionUID = 1L;
	@ApiModelProperty(value = "每页数量")
	private String limit;

	@ApiModelProperty(value = "当前页数")
	private String page;

	@ApiModelProperty(value = "排序字段")
	private String orderBy;

	@ApiModelProperty(value = "排序方式")
	private String orderType;

	@ApiModelProperty(value = "企业选择")
	private List<String> companyIds;

}
